/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.ackedqueue.AckedBatch;
import org.logstash.ackedqueue.ext.JRubyAckedQueueExt;
import org.logstash.execution.MemoryReadBatch;
import org.logstash.execution.QueueBatch;
import org.logstash.ext.JrubyEventExtLibrary;

public final class AckedReadBatch
implements QueueBatch {
    private AckedBatch ackedBatch;
    private RubyHash originals;
    private RubyHash generated;

    public static AckedReadBatch create(JRubyAckedQueueExt queue, int size, long timeout) {
        return new AckedReadBatch(queue, size, timeout);
    }

    private AckedReadBatch(JRubyAckedQueueExt queue, int size, long timeout) {
        AckedBatch batch;
        try {
            batch = queue.readBatch(size, timeout);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (batch == null) {
            this.originals = RubyHash.newHash((Ruby)RubyUtil.RUBY);
            this.ackedBatch = null;
        } else {
            this.ackedBatch = batch;
            this.originals = this.ackedBatch.toRubyHash(RubyUtil.RUBY);
        }
        this.generated = RubyHash.newHash((Ruby)RubyUtil.RUBY);
    }

    @Override
    public void merge(IRubyObject event) {
        if (!event.isNil() && !this.originals.containsKey((Object)event)) {
            this.generated.put((Object)event, (Object)RubyUtil.RUBY.getTrue());
        }
    }

    @Override
    public RubyArray to_a() {
        RubyArray result = RubyUtil.RUBY.newArray(this.filteredSize());
        for (JrubyEventExtLibrary.RubyEvent event : this.originals.keys()) {
            if (MemoryReadBatch.isCancelled((IRubyObject)event)) continue;
            result.append((IRubyObject)event);
        }
        for (JrubyEventExtLibrary.RubyEvent event : this.generated.keys()) {
            if (MemoryReadBatch.isCancelled((IRubyObject)event)) continue;
            result.append((IRubyObject)event);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.ackedBatch != null) {
            this.ackedBatch.close();
        }
    }

    @Override
    public int filteredSize() {
        return this.originals.size() + this.generated.size();
    }
}

