/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model;

import org.jfree.layouting.input.style.keys.text.TextAlign;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.EmptyBoxDefinition;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.ParagraphPoolBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;

public class ParagraphRenderBox
extends BlockRenderBox {
    private ParagraphPoolBox pool = new ParagraphPoolBox(EmptyBoxDefinition.getInstance());
    private LineBoxRenderBox lineboxContainer;
    private CSSValue textAlignment;
    private CSSValue lastLineAlignment;
    private long lineBoxAge;
    private long minorLayoutAge;
    private long majorLayoutAge;

    public ParagraphRenderBox(BoxDefinition boxDefinition) {
        super(boxDefinition);
        this.pool.setParent(this);
        this.lineboxContainer = new LineBoxRenderBox(EmptyBoxDefinition.getInstance());
        this.lineboxContainer.setParent(this);
    }

    @Override
    public void appyStyle(LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        super.appyStyle(layoutContext, outputProcessorMetaData);
        CSSValue cSSValue = layoutContext.getValue(TextStyleKeys.TEXT_ALIGN);
        CSSValue cSSValue2 = layoutContext.getValue(TextStyleKeys.TEXT_ALIGN_LAST);
        this.textAlignment = this.createAlignment(cSSValue);
        this.lastLineAlignment = this.textAlignment == TextAlign.JUSTIFY ? this.createAlignment(cSSValue2) : this.textAlignment;
        this.pool.appyStyle(layoutContext, outputProcessorMetaData);
        this.lineboxContainer.appyStyle(layoutContext, outputProcessorMetaData);
    }

    @Override
    public RenderNode derive(boolean bl) {
        ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)super.derive(bl);
        paragraphRenderBox.pool = (ParagraphPoolBox)this.pool.derive(bl);
        paragraphRenderBox.pool.setParent(paragraphRenderBox);
        paragraphRenderBox.lineboxContainer = (LineBoxRenderBox)this.lineboxContainer.derive(bl);
        paragraphRenderBox.lineboxContainer.setParent(paragraphRenderBox);
        if (!bl) {
            paragraphRenderBox.lineBoxAge = 0L;
        }
        return paragraphRenderBox;
    }

    @Override
    public RenderNode hibernate() {
        ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)super.derive(false);
        paragraphRenderBox.setHibernated(true);
        paragraphRenderBox.pool = (ParagraphPoolBox)this.pool.hibernate();
        paragraphRenderBox.pool.setParent(paragraphRenderBox);
        paragraphRenderBox.lineboxContainer = (LineBoxRenderBox)this.lineboxContainer.hibernate();
        paragraphRenderBox.lineBoxAge = 0L;
        return paragraphRenderBox;
    }

    private CSSValue createAlignment(CSSValue cSSValue) {
        if (TextAlign.LEFT.equals(cSSValue) || TextAlign.START.equals(cSSValue)) {
            return TextAlign.LEFT;
        }
        if (TextAlign.RIGHT.equals(cSSValue) || TextAlign.END.equals(cSSValue)) {
            return TextAlign.RIGHT;
        }
        if (TextAlign.CENTER.equals(cSSValue)) {
            return TextAlign.CENTER;
        }
        if (TextAlign.JUSTIFY.equals(cSSValue)) {
            return TextAlign.JUSTIFY;
        }
        return TextAlign.LEFT;
    }

    @Override
    public final void addChild(RenderNode renderNode) {
        this.pool.addChild(renderNode);
    }

    protected void addDirectly(RenderNode renderNode) {
        if (renderNode instanceof ParagraphPoolBox) {
            ParagraphPoolBox paragraphPoolBox = (ParagraphPoolBox)renderNode;
            paragraphPoolBox.trim();
        }
        super.addGeneratedChild(renderNode);
    }

    @Override
    public final void clear() {
        this.pool.clear();
        this.lineboxContainer.clear();
        super.clear();
        this.lineBoxAge = 0L;
    }

    public final void clearLayout() {
        super.clear();
        this.lineBoxAge = 0L;
    }

    @Override
    public RenderBox getInsertationPoint() {
        return this.pool.getInsertationPoint();
    }

    @Override
    public boolean isAppendable() {
        return this.pool.isAppendable();
    }

    @Override
    public RenderNode findNodeById(Object object) {
        return super.findNodeById(object);
    }

    @Override
    public boolean isEmpty() {
        return this.pool.isEmpty();
    }

    @Override
    public boolean isDiscardable() {
        return this.pool.isDiscardable();
    }

    public CSSValue getLastLineAlignment() {
        return this.lastLineAlignment;
    }

    public CSSValue getTextAlignment() {
        return this.textAlignment;
    }

    public BlockRenderBox getLineboxContainer() {
        return this.lineboxContainer;
    }

    public InlineRenderBox getPool() {
        return this.pool;
    }

    public long getLineBoxAge() {
        return this.lineBoxAge;
    }

    public void setLineBoxAge(long l) {
        this.lineBoxAge = l;
    }

    public long getMinorLayoutAge() {
        return this.minorLayoutAge;
    }

    public void setMinorLayoutAge(long l) {
        this.minorLayoutAge = l;
    }

    public long getMajorLayoutAge() {
        return this.majorLayoutAge;
    }

    public void setMajorLayoutAge(long l) {
        this.majorLayoutAge = l;
    }

    @Override
    public Object getInstanceId() {
        return this.pool.getInstanceId();
    }

    private static class LineBoxRenderBox
    extends BlockRenderBox {
        private LineBoxRenderBox(BoxDefinition boxDefinition) {
            super(boxDefinition);
        }
    }
}

