/*
 * Copyright (C) 2017 Purism SPC
 *
 * SPDX-License-Identifier: LGPL-2.1+
 */

#pragma once

#if !defined(_HANDY_INSIDE) && !defined(HANDY_COMPILATION)
#error "Only <handy.h> can be included directly."
#endif

/**
 * SECTION:hdy-version
 * @short_description: Handy version checking
 *
 * Handy provides macros to check the version of the library at compile-time
 */

/**
 * HDY_MAJOR_VERSION:
 *
 * Hdy major version component (e.g. 1 if %HDY_VERSION is 1.2.3)
 */
#define HDY_MAJOR_VERSION              (0)

/**
 * HDY_MINOR_VERSION:
 *
 * Hdy minor version component (e.g. 2 if %HDY_VERSION is 1.2.3)
 */
#define HDY_MINOR_VERSION              (0)

/**
 * HDY_MICRO_VERSION:
 *
 * Hdy micro version component (e.g. 3 if %HDY_VERSION is 1.2.3)
 */
#define HDY_MICRO_VERSION              (11)

/**
 * HDY_VERSION
 *
 * Hdy version.
 */
#define HDY_VERSION                    (0.0.11)

/**
 * HDY_VERSION_S:
 *
 * Handy version, encoded as a string, useful for printing and
 * concatenation.
 */
#define HDY_VERSION_S                  "0.0.11"

#define HDY_ENCODE_VERSION(major,minor,micro) \
        ((major) << 24 | (minor) << 16 | (micro) << 8)

/**
 * HDY_VERSION_HEX:
 *
 * Handy version, encoded as an hexadecimal number, useful for
 * integer comparisons.
 */
#define HDY_VERSION_HEX \
        (HDY_ENCODE_VERSION (HDY_MAJOR_VERSION, HDY_MINOR_VERSION, HDY_MICRO_VERSION))

/**
 * HDY_CHECK_VERSION:
 * @major: required major version
 * @minor: required minor version
 * @micro: required micro version
 *
 * Compile-time version checking. Evaluates to %TRUE if the version
 * of handy is greater than the required one.
 */
#define HDY_CHECK_VERSION(major,minor,micro)   \
        (HDY_MAJOR_VERSION > (major) || \
         (HDY_MAJOR_VERSION == (major) && HDY_MINOR_VERSION > (minor)) || \
         (HDY_MAJOR_VERSION == (major) && HDY_MINOR_VERSION == (minor) && \
          HDY_MICRO_VERSION >= (micro)))
