import { useEffect } from 'react';
var useBeforeUnload = function (enabled, message) {
    if (enabled === void 0) { enabled = true; }
    useEffect(function () {
        if (!enabled) {
            return;
        }
        var handler = function (event) {
            event.preventDefault();
            if (message) {
                event.returnValue = message;
            }
            return message;
        };
        window.addEventListener('beforeunload', handler);
        return function () { return window.removeEventListener('beforeunload', handler); };
    }, [message, enabled]);
};
export default useBeforeUnload;
