"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const stream_1 = require("stream");
const stream_2 = require("../readers/stream");
const provider_1 = require("./provider");
class ProviderStream extends provider_1.default {
    constructor() {
        super(...arguments);
        this._reader = new stream_2.default(this._settings);
    }
    read(task) {
        const root = this._getRootDirectory(task);
        const options = this._getReaderOptions(task);
        const source = this.api(root, task, options);
        const dest = new stream_1.Readable({ objectMode: true, read: () => { } });
        source
            .once('error', (error) => dest.emit('error', error))
            .on('data', (entry) => dest.emit('data', options.transform(entry)))
            .once('end', () => dest.emit('end'));
        return dest;
    }
    api(root, task, options) {
        if (task.dynamic) {
            return this._reader.dynamic(root, options);
        }
        return this._reader.static(task.patterns, options);
    }
}
exports.default = ProviderStream;
