"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Reporter = void 0;

var _util = require("./util");

var _metrics = require("./metrics");

var _storage = require("./storage");

var _report = require("./report");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var Reporter =
/*#__PURE__*/
function () {
  function Reporter(config) {
    var _this = this;

    _classCallCheck(this, Reporter);

    _defineProperty(this, "checkInterval", void 0);

    _defineProperty(this, "interval", void 0);

    _defineProperty(this, "http", void 0);

    _defineProperty(this, "reportManager", void 0);

    _defineProperty(this, "storageManager", void 0);

    _defineProperty(this, "debug", void 0);

    _defineProperty(this, "retryCount", 0);

    _defineProperty(this, "maxRetries", 3);

    _defineProperty(this, "start", function () {
      if (!_this.interval) {
        _this.interval = setTimeout(function () {
          _this.interval = null;

          _this.sendReports();
        }, _this.checkInterval);
      }
    });

    _defineProperty(this, "reportUiStats", function (appName, type, eventNames, count) {
      var metrics = (0, _util.wrapArray)(eventNames).map(function (eventName) {
        _this.log("".concat(type, " Metric -> (").concat(appName, ":").concat(eventName, "):"));

        var report = (0, _metrics.createUiStatsMetric)({
          type: type,
          appName: appName,
          eventName: eventName,
          count: count
        });

        _this.log(report);

        return report;
      });

      _this.saveToReport(metrics);
    });

    _defineProperty(this, "reportUserAgent", function (appName) {
      _this.log("Reporting user-agent.");

      var report = (0, _metrics.trackUsageAgent)(appName);

      _this.saveToReport([report]);
    });

    _defineProperty(this, "sendReports", function _callee() {
      var versionMismatch;
      return regeneratorRuntime.async(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (_this.reportManager.isReportEmpty()) {
                _context.next = 13;
                break;
              }

              _context.prev = 1;
              _context.next = 4;
              return regeneratorRuntime.awrap(_this.http(_this.reportManager.report));

            case 4:
              _this.flushReport();

              _context.next = 13;
              break;

            case 7:
              _context.prev = 7;
              _context.t0 = _context["catch"](1);

              _this.log("Error Sending Metrics Report ".concat(_context.t0));

              _this.retryCount = _this.retryCount + 1;
              versionMismatch = _this.reportManager.report.reportVersion !== _report.ReportManager.REPORT_VERSION;

              if (versionMismatch || _this.retryCount > _this.maxRetries) {
                _this.flushReport();
              }

            case 13:
              _this.start();

            case 14:
            case "end":
              return _context.stop();
          }
        }
      }, null, null, [[1, 7]]);
    });

    var http = config.http,
        storage = config.storage,
        debug = config.debug,
        _config$checkInterval = config.checkInterval,
        checkInterval = _config$checkInterval === void 0 ? 90000 : _config$checkInterval,
        _config$storageKey = config.storageKey,
        storageKey = _config$storageKey === void 0 ? 'analytics' : _config$storageKey;
    this.http = http;
    this.checkInterval = checkInterval;
    this.interval = null;
    this.storageManager = new _storage.ReportStorageManager(storageKey, storage);
    var storedReport = this.storageManager.get();
    this.reportManager = new _report.ReportManager(storedReport);
    this.debug = !!debug;
  }

  _createClass(Reporter, [{
    key: "saveToReport",
    value: function saveToReport(newMetrics) {
      this.reportManager.assignReports(newMetrics);
      this.storageManager.store(this.reportManager.report);
    }
  }, {
    key: "flushReport",
    value: function flushReport() {
      this.retryCount = 0;
      this.reportManager.clearReport();
      this.storageManager.store(this.reportManager.report);
    }
  }, {
    key: "log",
    value: function log(message) {
      if (this.debug) {
        // eslint-disable-next-line
        console.debug(message);
      }
    }
  }]);

  return Reporter;
}();

exports.Reporter = Reporter;