"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var specs_1 = require("../../../../specs");
var index_1 = require("../../../index");
var get_oriented_projected_pointer_position_1 = require("./get_oriented_projected_pointer_position");
var compute_series_geometries_1 = require("./compute_series_geometries");
var get_geometries_index_keys_1 = require("./get_geometries_index_keys");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var getPointerEventSelector = re_reselect_1.default([
    get_chart_id_1.getChartIdSelector,
    get_oriented_projected_pointer_position_1.getOrientedProjectedPointerPositionSelector,
    compute_series_geometries_1.computeSeriesGeometriesSelector,
    get_geometries_index_keys_1.getGeometriesIndexKeysSelector,
], function (chartId, orientedProjectedPointerPosition, seriesGeometries, geometriesIndexKeys) {
    return getPointerEvent(chartId, orientedProjectedPointerPosition, seriesGeometries.scales.xScale, geometriesIndexKeys);
})(get_chart_id_1.getChartIdSelector);
function getPointerEvent(chartId, orientedProjectedPoinerPosition, xScale, geometriesIndexKeys) {
    // update che cursorBandPosition based on chart configuration
    if (!xScale) {
        return {
            chartId: chartId,
            type: specs_1.PointerEventType.Out,
        };
    }
    var x = orientedProjectedPoinerPosition.x, y = orientedProjectedPoinerPosition.y;
    if (x === -1 || y === -1) {
        return {
            chartId: chartId,
            type: specs_1.PointerEventType.Out,
        };
    }
    var xValue = xScale.invertWithStep(x, geometriesIndexKeys);
    if (!xValue) {
        return {
            chartId: chartId,
            type: specs_1.PointerEventType.Out,
        };
    }
    return {
        chartId: chartId,
        type: specs_1.PointerEventType.Over,
        unit: xScale.unit,
        scale: xScale.type,
        value: xValue.value,
    };
}
function hasPointerEventChanged(prevPointerEvent, nextPointerEvent) {
    if (nextPointerEvent && prevPointerEvent.type !== nextPointerEvent.type) {
        return true;
    }
    if (nextPointerEvent &&
        prevPointerEvent.type === nextPointerEvent.type &&
        prevPointerEvent.type === specs_1.PointerEventType.Out) {
        return false;
    }
    // if something changed in the pointerEvent than recompute
    if (nextPointerEvent &&
        prevPointerEvent.type === specs_1.PointerEventType.Over &&
        nextPointerEvent.type === specs_1.PointerEventType.Over &&
        (prevPointerEvent.value !== nextPointerEvent.value ||
            prevPointerEvent.scale !== nextPointerEvent.scale ||
            prevPointerEvent.unit !== nextPointerEvent.unit)) {
        return true;
    }
    return false;
}
function createOnPointerMoveCaller() {
    var prevPointerEvent = null;
    var selector = null;
    return function (state) {
        if (selector === null && state.chartType === index_1.ChartTypes.XYAxis) {
            selector = re_reselect_1.default([get_settings_specs_1.getSettingsSpecSelector, getPointerEventSelector, get_chart_id_1.getChartIdSelector], function (settings, nextPointerEvent, chartId) {
                if (prevPointerEvent === null) {
                    prevPointerEvent = {
                        chartId: chartId,
                        type: specs_1.PointerEventType.Out,
                    };
                }
                var tempPrev = __assign({}, prevPointerEvent);
                // we have to update the prevPointerEvents before possiibly calling the onPointerUpdate
                // to avoid a recursive loop of calls caused by the impossibility to update the prevPointerEvent
                prevPointerEvent = nextPointerEvent;
                if (settings && settings.onPointerUpdate && hasPointerEventChanged(tempPrev, nextPointerEvent)) {
                    settings.onPointerUpdate(nextPointerEvent);
                }
            })({
                keySelector: get_chart_id_1.getChartIdSelector,
            });
        }
        if (selector) {
            selector(state);
        }
    };
}
exports.createOnPointerMoveCaller = createOnPointerMoveCaller;
//# sourceMappingURL=on_pointer_move_caller.js.map