/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Objects;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.policyeditor.CustomPermission;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditor;

public class CustomPolicyViewer
extends JFrame {
    private final Collection<CustomPermission> customPermissions = new TreeSet<CustomPermission>();
    private final JScrollPane scrollPane = new JScrollPane();
    private final DefaultListModel<CustomPermission> listModel = new DefaultListModel();
    private final JList<CustomPermission> list = new JList<CustomPermission>(this.listModel);
    private final JButton addButton = new JButton();
    private final JButton removeButton = new JButton();
    private final JButton closeButton = new JButton();
    private final JLabel listLabel = new JLabel();
    private final ActionListener addButtonAction;
    private final ActionListener removeButtonAction;
    private final ActionListener closeButtonAction;
    private final PolicyEditor parent;
    private final String codebase;

    public CustomPolicyViewer(PolicyEditor parent, String codebase) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(codebase);
        this.parent = parent;
        this.codebase = codebase;
        this.setLayout(new GridBagLayout());
        this.setTitle(Translator.R("PECPTitle"));
        this.customPermissions.addAll(parent.getCustomPermissions(codebase));
        for (CustomPermission perm : this.customPermissions) {
            this.listModel.addElement(perm);
        }
        this.addButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String prefill = Translator.R("PECPType") + " " + Translator.R("PECPTarget") + " [" + Translator.R("PECPActions") + "]";
                String string = JOptionPane.showInputDialog(CustomPolicyViewer.this, Translator.R("PECPPrompt"), prefill);
                if (string == null || string.isEmpty()) {
                    return;
                }
                String[] parts = (string = string.replaceAll("\\s+", " ").trim()).split(" ");
                if (parts.length < 2) {
                    return;
                }
                String type = parts[0];
                String target = parts[1];
                String actions = parts.length > 2 ? parts[2] : "";
                CustomPermission perm = new CustomPermission(type, target, actions);
                CustomPolicyViewer.this.addCustomPermission(perm);
            }
        };
        this.addButton.setText(Translator.R("PECPAddButton"));
        this.addButton.addActionListener(this.addButtonAction);
        this.removeButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomPermission selected = (CustomPermission)CustomPolicyViewer.this.list.getSelectedValue();
                if (selected == null) {
                    return;
                }
                CustomPolicyViewer.this.removeCustomPermission(selected);
            }
        };
        this.removeButton.setText(Translator.R("PECPRemoveButton"));
        this.removeButton.addActionListener(this.removeButtonAction);
        this.closeButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomPolicyViewer.this.quit();
            }
        };
        this.closeButton.setText(Translator.R("PECPCloseButton"));
        this.closeButton.addActionListener(this.closeButtonAction);
        String codebaseText = codebase.trim().isEmpty() ? Translator.R("PEGlobalSettings") : codebase;
        this.listLabel.setText(Translator.R("PECPListLabel", codebaseText));
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.list.setSelectedIndex(0);
        this.setupLayout();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CustomPolicyViewer.this.quit();
            }
        });
    }

    private void setupLayout() {
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 0;
        EmptyBorder border = new EmptyBorder(2, 2, 2, 2);
        this.listLabel.setBorder(border);
        this.add((Component)this.listLabel, labelConstraints);
        GridBagConstraints scrollPaneConstraints = new GridBagConstraints();
        scrollPaneConstraints.gridx = 0;
        scrollPaneConstraints.gridy = 1;
        scrollPaneConstraints.weightx = 1.0;
        scrollPaneConstraints.weighty = 1.0;
        scrollPaneConstraints.gridwidth = 3;
        scrollPaneConstraints.fill = 1;
        this.list.setSelectionMode(0);
        this.scrollPane.setViewportView(this.list);
        this.add((Component)this.scrollPane, scrollPaneConstraints);
        GridBagConstraints addButtonConstraints = new GridBagConstraints();
        addButtonConstraints.gridx = 0;
        addButtonConstraints.gridy = scrollPaneConstraints.gridy + 1;
        addButtonConstraints.fill = 2;
        this.add((Component)this.addButton, addButtonConstraints);
        GridBagConstraints removeButtonConstraints = new GridBagConstraints();
        removeButtonConstraints.gridx = addButtonConstraints.gridx + 1;
        removeButtonConstraints.gridy = addButtonConstraints.gridy;
        removeButtonConstraints.fill = 2;
        this.add((Component)this.removeButton, removeButtonConstraints);
        GridBagConstraints closeButtonConstraints = new GridBagConstraints();
        closeButtonConstraints.gridx = removeButtonConstraints.gridx + 1;
        closeButtonConstraints.gridy = removeButtonConstraints.gridy;
        closeButtonConstraints.fill = 2;
        this.add((Component)this.closeButton, closeButtonConstraints);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
    }

    private void quit() {
        this.parent.customPolicyViewerClosing();
        this.dispose();
    }

    private void updateCustomPermissions() {
        this.parent.setChangesMade(true);
        this.parent.clearCustomPermissions(this.codebase);
        for (CustomPermission permission : this.customPermissions) {
            this.parent.addCustomPermission(this.codebase, permission);
        }
    }

    void addCustomPermission(CustomPermission permission) {
        Objects.requireNonNull(permission);
        if (this.customPermissions.add(permission)) {
            this.listModel.addElement(permission);
            this.updateCustomPermissions();
        }
        this.list.setSelectedValue(permission, true);
    }

    void removeCustomPermission(CustomPermission permission) {
        Objects.requireNonNull(permission);
        this.customPermissions.remove(permission);
        this.listModel.removeElement(permission);
        this.updateCustomPermissions();
    }

    Collection<CustomPermission> getCopyOfCustomPermissions() {
        return new TreeSet<CustomPermission>(this.customPermissions);
    }
}

