/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;

public class LimitedByteBuffer {
    byte[] value;
    int count;
    int absmax;

    public LimitedByteBuffer(int initial, int amax) {
        this.value = new byte[initial];
        this.count = 0;
        this.absmax = amax;
    }

    public void append(byte b) throws IOException {
        int newCount = this.count + 1;
        if (newCount > this.value.length) {
            if (newCount > this.absmax) {
                int maxResultSizeMBytes = this.absmax >> 20;
                throw new IOException("Decompiler results exceeded payload limit of " + maxResultSizeMBytes + " MBytes");
            }
            int newcapacity = this.value.length * 2;
            if (newcapacity < 0) {
                newcapacity = Integer.MAX_VALUE;
            }
            if (newcapacity > this.absmax) {
                newcapacity = this.absmax;
            }
            this.value = Arrays.copyOf(this.value, newcapacity);
        }
        this.value[this.count++] = b;
    }

    public ByteArrayInputStream getInputStream() {
        return new ByteArrayInputStream(this.value, 0, this.count);
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }
}

