/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BinaryField;
import db.DBFieldIterator;
import db.DBHandle;
import db.Field;
import db.IndexBuffer;
import db.IndexTable;
import db.Record;
import db.Schema;
import db.Table;
import db.TableRecord;
import java.io.IOException;

class VarIndexTable
extends IndexTable {
    private static final Class<?>[] fieldClasses = new Class[]{BinaryField.class};
    private static final String[] fieldNames = new String[]{"IndexBuffer"};
    private Schema indexSchema;

    VarIndexTable(Table primaryTable, int colIndex) throws IOException {
        this(primaryTable, primaryTable.getDBHandle().getMasterTable().createTableRecord(primaryTable.getName(), new Schema(0, primaryTable.getSchema().getField(colIndex).getClass(), "IndexKey", fieldClasses, fieldNames), colIndex));
    }

    VarIndexTable(Table primaryTable, TableRecord indexTableRecord) {
        super(primaryTable, indexTableRecord);
        this.indexSchema = this.indexTable.getSchema();
    }

    @Override
    long[] findPrimaryKeys(Field indexValue) throws IOException {
        if (!indexValue.getClass().equals(this.fieldType.getClass())) {
            throw new IllegalArgumentException("Incorrect indexed field type");
        }
        Record indexRecord = this.indexTable.getRecord(indexValue);
        if (indexRecord == null) {
            return emptyKeyArray;
        }
        IndexBuffer indexBuffer = new IndexBuffer(indexValue, indexRecord.getBinaryData(0));
        return indexBuffer.getPrimaryKeys();
    }

    @Override
    int getKeyCount(Field indexValue) throws IOException {
        if (!indexValue.getClass().equals(this.fieldType.getClass())) {
            throw new IllegalArgumentException("Incorrect indexed field type");
        }
        Record indexRecord = this.indexTable.getRecord(indexValue);
        if (indexRecord == null) {
            return 0;
        }
        IndexBuffer indexBuffer = new IndexBuffer(indexValue, indexRecord.getBinaryData(0));
        return indexBuffer.keyCount;
    }

    @Override
    void addEntry(Record record) throws IOException {
        Field indexField = record.getField(this.colIndex);
        Record indexRecord = this.indexTable.getRecord(indexField);
        if (indexRecord == null) {
            indexRecord = this.indexSchema.createRecord(indexField);
        }
        IndexBuffer indexBuffer = new IndexBuffer(indexField, indexRecord.getBinaryData(0));
        indexBuffer.addEntry(record.getKey());
        indexRecord.setBinaryData(0, indexBuffer.getData());
        this.indexTable.putRecord(indexRecord);
    }

    @Override
    void deleteEntry(Record record) throws IOException {
        Field indexField = record.getField(this.colIndex);
        Record indexRecord = this.indexTable.getRecord(indexField);
        if (indexRecord != null) {
            IndexBuffer indexBuffer = new IndexBuffer(indexField, indexRecord.getBinaryData(0));
            indexBuffer.deleteEntry(record.getKey());
            byte[] data = indexBuffer.getData();
            if (data == null) {
                this.indexTable.deleteRecord(indexField);
            } else {
                indexRecord.setBinaryData(0, data);
                this.indexTable.putRecord(indexRecord);
            }
        }
    }

    private IndexBuffer getIndexBuffer(Field indexKey) throws IOException {
        Record indexRec = this.indexTable.getRecord(indexKey);
        return indexRec != null ? new IndexBuffer(indexKey, indexRec.getBinaryData(0)) : null;
    }

    @Override
    DBFieldIterator indexIterator() throws IOException {
        return new IndexFieldIterator();
    }

    @Override
    DBFieldIterator indexIterator(Field minField, Field maxField, boolean atMin) throws IOException {
        return new IndexFieldIterator(minField, maxField, atMin);
    }

    @Override
    DBFieldIterator indexIterator(Field minField, Field maxField, Field startField, boolean before) throws IOException {
        return new IndexFieldIterator(minField, maxField, startField, before);
    }

    class IndexFieldIterator
    implements DBFieldIterator {
        private Field lastKey;
        private Field keyField;
        private DBFieldIterator indexIterator;
        private boolean hasNext = false;
        private boolean hasPrev = false;

        IndexFieldIterator() throws IOException {
            this(null, null, true);
        }

        IndexFieldIterator(Field minValue, Field maxValue, boolean atMin) throws IOException {
            Field start = atMin ? minValue : maxValue;
            this.indexIterator = VarIndexTable.this.indexTable.fieldKeyIterator(minValue, maxValue, start);
            if (this.indexIterator.hasNext()) {
                this.indexIterator.next();
                if (atMin) {
                    this.indexIterator.previous();
                }
            }
        }

        IndexFieldIterator(Field minValue, Field maxValue, Field startValue, boolean before) throws IOException {
            if (startValue == null) {
                throw new IllegalArgumentException("starting index value required");
            }
            this.indexIterator = VarIndexTable.this.indexTable.fieldKeyIterator(minValue, maxValue, startValue);
            if (this.indexIterator.hasNext()) {
                Field f = this.indexIterator.next();
                if (before || !f.equals(startValue)) {
                    this.indexIterator.previous();
                }
            }
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.hasNext) {
                return true;
            }
            Field key = this.indexIterator.next();
            if (key == null) {
                return false;
            }
            this.keyField = key;
            this.hasNext = true;
            this.hasPrev = false;
            return true;
        }

        @Override
        public boolean hasPrevious() throws IOException {
            if (this.hasPrev) {
                return true;
            }
            Field key = this.indexIterator.previous();
            if (key == null) {
                return false;
            }
            this.keyField = key;
            this.hasNext = false;
            this.hasPrev = true;
            return true;
        }

        @Override
        public Field next() throws IOException {
            if (this.hasNext || this.hasNext()) {
                this.hasNext = false;
                this.hasPrev = true;
                this.lastKey = this.keyField;
                return this.keyField;
            }
            return null;
        }

        @Override
        public Field previous() throws IOException {
            if (this.hasPrev || this.hasPrevious()) {
                this.hasNext = true;
                this.hasPrev = false;
                this.lastKey = this.keyField;
                return this.keyField;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean delete() throws IOException {
            if (this.lastKey == null) {
                return false;
            }
            DBHandle dBHandle = VarIndexTable.this.db;
            synchronized (dBHandle) {
                IndexBuffer indexBuf = VarIndexTable.this.getIndexBuffer(this.lastKey);
                if (indexBuf != null) {
                    long[] keys = indexBuf.getPrimaryKeys();
                    for (int i = 0; i < keys.length; ++i) {
                        VarIndexTable.this.primaryTable.deleteRecord(keys[i]);
                    }
                }
                this.lastKey = null;
                return true;
            }
        }
    }
}

