/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BTreeNode;
import db.FixedRecNode;
import db.LongKeyInteriorNode;
import db.LongKeyNode;
import db.LongKeyRecordNode;
import db.Schema;
import db.VarKeyInteriorNode;
import db.VarKeyNode;
import db.VarKeyRecordNode;
import db.VarRecNode;
import db.buffers.BufferMgr;
import db.buffers.DataBuffer;
import ghidra.util.datastruct.IntObjectHashtable;
import ghidra.util.exception.AssertException;
import java.io.IOException;

class NodeMgr {
    static final int NODE_TYPE_SIZE = 1;
    static final int NODE_TYPE_OFFSET = 0;
    static final int NODE_HEADER_SIZE = 1;
    static final byte LONGKEY_INTERIOR_NODE = 0;
    static final byte LONGKEY_VAR_REC_NODE = 1;
    static final byte LONGKEY_FIXED_REC_NODE = 2;
    static final byte VARKEY_INTERIOR_NODE = 3;
    static final byte VARKEY_REC_NODE = 4;
    static final byte CHAINED_BUFFER_INDEX_NODE = 8;
    static final byte CHAINED_BUFFER_DATA_NODE = 9;
    private BufferMgr bufferMgr;
    private Schema schema;
    private int leafRecordCnt = 0;
    private IntObjectHashtable<BTreeNode> nodeTable = new IntObjectHashtable(10);

    NodeMgr(BufferMgr bufferMgr, Schema schema) {
        this.bufferMgr = bufferMgr;
        this.schema = schema;
    }

    BufferMgr getBufferMgr() {
        return this.bufferMgr;
    }

    int releaseNodes() throws IOException {
        int[] bufferIds;
        for (int bufferId : bufferIds = this.nodeTable.getKeys()) {
            BTreeNode node = (BTreeNode)this.nodeTable.get(bufferId);
            if (node instanceof LongKeyRecordNode || node instanceof VarKeyRecordNode) {
                this.leafRecordCnt -= node.getKeyCount();
            }
            this.bufferMgr.releaseBuffer(node.getBuffer());
        }
        this.nodeTable.removeAll();
        int result = -this.leafRecordCnt;
        this.leafRecordCnt = 0;
        return result;
    }

    void releaseReadOnlyNode(int bufferId) throws IOException {
        BTreeNode node = (BTreeNode)this.nodeTable.get(bufferId);
        if (node.getBuffer().isDirty()) {
            throw new IOException("Releasing modified buffer node as read-only");
        }
        if (node instanceof LongKeyRecordNode || node instanceof VarKeyRecordNode) {
            this.leafRecordCnt -= node.getKeyCount();
        }
        this.bufferMgr.releaseBuffer(node.getBuffer());
        this.nodeTable.remove(bufferId);
    }

    void addNode(BTreeNode node) {
        this.nodeTable.put(node.getBufferId(), (Object)node);
    }

    void deleteNode(BTreeNode node) throws IOException {
        int bufferId = node.getBufferId();
        this.nodeTable.remove(bufferId);
        this.bufferMgr.releaseBuffer(node.getBuffer());
        this.bufferMgr.deleteBuffer(bufferId);
    }

    LongKeyNode getLongKeyNode(int bufferId) throws IOException {
        LongKeyNode node = (LongKeyNode)this.nodeTable.get(bufferId);
        if (node != null) {
            return node;
        }
        DataBuffer buf = this.bufferMgr.getBuffer(bufferId);
        byte nodeType = NodeMgr.getNodeType(buf);
        switch (nodeType) {
            case 1: {
                node = new VarRecNode(this, buf);
                this.leafRecordCnt += node.keyCount;
                break;
            }
            case 2: {
                node = new FixedRecNode(this, buf, this.schema.getFixedLength());
                this.leafRecordCnt += node.keyCount;
                break;
            }
            case 0: {
                node = new LongKeyInteriorNode(this, buf);
                break;
            }
            default: {
                throw new AssertException("Unexpected Node Type (" + nodeType + ") found, expecting LongKeyNode");
            }
        }
        return node;
    }

    VarKeyNode getVarKeyNode(int bufferId) throws IOException {
        VarKeyNode node = (VarKeyNode)this.nodeTable.get(bufferId);
        if (node != null) {
            return node;
        }
        DataBuffer buf = this.bufferMgr.getBuffer(bufferId);
        byte nodeType = NodeMgr.getNodeType(buf);
        switch (nodeType) {
            case 4: {
                node = new VarKeyRecordNode(this, buf);
                this.leafRecordCnt += node.keyCount;
                break;
            }
            case 3: {
                node = new VarKeyInteriorNode(this, buf);
                break;
            }
            default: {
                throw new AssertException("Unexpected Node Type (" + nodeType + ") found, expecting VarKeyNode");
            }
        }
        return node;
    }

    static byte getNodeType(DataBuffer buffer) {
        return buffer.getByte(0);
    }

    static void setNodeType(DataBuffer buffer, byte nodeType) {
        buffer.putByte(0, nodeType);
    }
}

