/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;

public final class DataUtilities {
    private DataUtilities() {
    }

    public static boolean isValidDataTypeName(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!Character.isISOControl(c)) continue;
            return false;
        }
        return true;
    }

    public static Data createData(Program program, Address addr, DataType newDataType, int length, boolean stackPointers, ClearDataMode clearMode) throws CodeUnitInsertionException {
        Listing listing = program.getListing();
        ReferenceManager refMgr = program.getReferenceManager();
        Data data = listing.getDataAt(addr);
        DataType existingDT = null;
        Reference extRef = null;
        int existingDataLen = addr.getAddressSpace().getAddressableUnitSize();
        if (data == null) {
            if (!(clearMode != ClearDataMode.CLEAR_ALL_CONFLICT_DATA && clearMode != ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA || (data = listing.getDataContaining(addr)) == null || clearMode != ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA || Undefined.isUndefined(data.getDataType()))) {
                data = null;
            }
            if (data == null) {
                throw new CodeUnitInsertionException("Could not create Data at address " + addr);
            }
        } else {
            Reference[] refs;
            existingDataLen = data.getLength();
            existingDT = data.getDataType();
            for (Reference ref : refs = refMgr.getReferencesFrom(addr)) {
                if (ref.getOperandIndex() != 0 || !ref.isExternalReference()) continue;
                extRef = ref;
                break;
            }
        }
        newDataType = newDataType.clone(program.getDataTypeManager());
        DataType realType = newDataType = DataUtilities.reconcileAppliedDataType(existingDT, newDataType, stackPointers);
        if (newDataType instanceof TypeDef) {
            realType = ((TypeDef)newDataType).getBaseDataType();
        }
        if (!(realType instanceof Dynamic) && !(realType instanceof FactoryDataType) && newDataType.equals(existingDT)) {
            return data;
        }
        DumbMemBufferImpl memBuf = new DumbMemBufferImpl(program.getMemory(), addr);
        DataTypeInstance dti = length > 0 && realType instanceof Dynamic && ((Dynamic)realType).canSpecifyLength() ? DataTypeInstance.getDataTypeInstance(newDataType, memBuf, length) : DataTypeInstance.getDataTypeInstance(newDataType, memBuf);
        if (dti == null) {
            throw new CodeUnitInsertionException("Could not create DataType " + newDataType.getDisplayName());
        }
        try {
            return listing.createData(addr, dti.getDataType(), dti.getLength());
        }
        catch (CodeUnitInsertionException codeUnitInsertionException) {
            if (clearMode == ClearDataMode.CLEAR_SINGLE_DATA) {
                listing.clearCodeUnits(addr, addr, false);
            } else {
                DataUtilities.checkEnoughSpace(program, addr, existingDataLen, dti, clearMode);
            }
            Data newData = listing.createData(addr, dti.getDataType(), dti.getLength());
            if (newDataType instanceof Pointer && extRef != null) {
                ExternalLocation extLoc = ((ExternalReference)extRef).getExternalLocation();
                try {
                    refMgr.addExternalReference(extRef.getFromAddress(), 0, extLoc, extRef.getSource(), extRef.getReferenceType());
                }
                catch (InvalidInputException e) {
                    throw new AssertException((Throwable)e);
                }
            }
            return newData;
        }
    }

    private static void checkEnoughSpace(Program program, Address addr, int existingDataLen, DataTypeInstance dti, ClearDataMode mode) throws CodeUnitInsertionException {
        Listing listing = program.getListing();
        int newSize = dti.getLength();
        if (newSize <= existingDataLen) {
            listing.clearCodeUnits(addr, addr, false);
            return;
        }
        try {
            Address end = addr.addNoWrap(existingDataLen - 1);
            Address newEnd = addr.addNoWrap(dti.getLength() - 1);
            Instruction instr = listing.getInstructionAfter(end);
            if (instr != null && instr.getMinAddress().compareTo(newEnd) <= 0) {
                throw new CodeUnitInsertionException("Not enough space to create DataType " + dti.getDataType().getDisplayName());
            }
            Data definedData = listing.getDefinedDataAfter(end);
            if (definedData != null && definedData.getMinAddress().compareTo(newEnd) <= 0) {
                if (mode == ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA && Undefined.isUndefined(definedData.getDataType())) {
                    end = definedData.getMaxAddress();
                    while (end.compareTo(newEnd) <= 0 && (definedData = listing.getDefinedDataAfter(end)) != null && definedData.getMinAddress().compareTo(newEnd) <= 0) {
                        if (!Undefined.isUndefined(definedData.getDataType())) {
                            throw new CodeUnitInsertionException("Not enough space to create DataType " + dti.getDataType().getDisplayName());
                        }
                        end = definedData.getMaxAddress();
                    }
                } else if (mode != ClearDataMode.CLEAR_ALL_CONFLICT_DATA) {
                    throw new CodeUnitInsertionException("Not enough space to create DataType " + dti.getDataType().getDisplayName());
                }
                listing.clearCodeUnits(addr, newEnd, false);
            } else {
                listing.clearCodeUnits(addr, addr, false);
            }
        }
        catch (AddressOverflowException e) {
            throw new CodeUnitInsertionException("Not enough space to create DataType " + dti.getDataType().getDisplayName());
        }
    }

    private static DataType stackPointers(Pointer pointer, DataType dataType) {
        DataType dt = pointer.getDataType();
        if (dt instanceof Pointer) {
            return pointer.newPointer(DataUtilities.stackPointers((Pointer)dt, dataType));
        }
        return pointer.newPointer(dataType);
    }

    public static DataType reconcileAppliedDataType(DataType originalDataType, DataType newDataType, boolean stackPointers) {
        if (newDataType == DataType.DEFAULT) {
            return newDataType;
        }
        DataType resultDt = newDataType;
        if (stackPointers && DataUtilities.isDefaultPointer(newDataType) && originalDataType instanceof Pointer) {
            resultDt = ((Pointer)newDataType).newPointer(originalDataType);
        } else if (stackPointers && originalDataType instanceof Pointer) {
            resultDt = DataUtilities.stackPointers((Pointer)originalDataType, newDataType);
        } else if (newDataType instanceof FunctionDefinition || newDataType instanceof TypeDef && ((TypeDef)newDataType).getBaseDataType() instanceof FunctionDefinition) {
            resultDt = new PointerDataType(newDataType);
        }
        return resultDt;
    }

    private static boolean isDefaultPointer(DataType dt) {
        if (!(dt instanceof Pointer)) {
            return false;
        }
        Pointer p = (Pointer)dt;
        DataType ptrDt = p.getDataType();
        return ptrDt == null || ptrDt == DataType.DEFAULT;
    }

    public static Data getDataAtLocation(ProgramLocation loc) {
        if (loc == null) {
            return null;
        }
        Address addr = loc.getAddress();
        Listing listing = loc.getProgram().getListing();
        CodeUnit cu = listing.getCodeUnitAt(addr);
        if (cu == null) {
            cu = listing.getCodeUnitContaining(addr);
        }
        if (cu instanceof Data) {
            Data d = (Data)cu;
            int[] compPath = loc.getComponentPath();
            if (compPath != null) {
                d = d.getComponent(compPath);
            }
            return d;
        }
        return null;
    }

    public static Data getDataAtAddress(Program program, Address address) {
        if (address == null) {
            return null;
        }
        Listing listing = program.getListing();
        CodeUnit cu = listing.getCodeUnitAt(address);
        if (cu instanceof Data) {
            return (Data)cu;
        }
        return null;
    }

    public static Address getMaxAddressOfUndefinedRange(Program program, Address addr) {
        Listing listing = program.getListing();
        Data data = listing.getDataContaining(addr);
        if (data == null || !Undefined.isUndefined(data.getDataType())) {
            return null;
        }
        Address endOfRangeAddress = data.getMaxAddress();
        MemoryBlock block = program.getMemory().getBlock(addr);
        if (block == null) {
            return null;
        }
        Address limitAddress = block.getEnd();
        CodeUnit cu = data;
        while (cu != null) {
            if (cu.getAddress().compareTo(limitAddress) > 0) {
                endOfRangeAddress = limitAddress;
                break;
            }
            if (!(cu instanceof Data) || !Undefined.isUndefined(cu.getDataType())) {
                endOfRangeAddress = cu.getMinAddress().previous();
                break;
            }
            endOfRangeAddress = cu.getMaxAddress();
            cu = listing.getDefinedCodeUnitAfter(endOfRangeAddress);
        }
        if (cu == null) {
            endOfRangeAddress = limitAddress;
        }
        return endOfRangeAddress;
    }

    public static boolean isUndefinedData(Program program, Address addr) {
        Data data = program.getListing().getDataAt(addr);
        return Undefined.isUndefined(data.getDataType());
    }

    public static Data getNextNonUndefinedDataAfter(Program program, Address addr, Address maxAddr) {
        Listing listing = program.getListing();
        Address currentAddress = addr;
        Data data = listing.getDefinedDataAfter(currentAddress);
        while (data != null && Undefined.isUndefined(data.getDataType()) && currentAddress.compareTo(maxAddr) <= 0) {
            currentAddress = data.getMaxAddress();
            data = listing.getDefinedDataAfter(currentAddress);
        }
        if (data != null && data.getAddress().compareTo(maxAddr) > 0) {
            return null;
        }
        return data;
    }

    public static Address findFirstConflictingAddress(Program program, Address addr, int length, boolean ignoreUndefinedData) {
        Address instructionAddr;
        InstructionIterator instructionIter;
        Instruction instruction;
        AddressSet addrSet = new AddressSet(addr, addr.add(length - 1));
        DataIterator definedDataIter = program.getListing().getDefinedData(addrSet, true);
        Data data = null;
        while (definedDataIter.hasNext()) {
            Data d = definedDataIter.next();
            if (ignoreUndefinedData && Undefined.isUndefined(d.getDataType())) continue;
            data = d;
            break;
        }
        Instruction instruction2 = instruction = (instructionIter = program.getListing().getInstructions(addrSet, true)).hasNext() ? instructionIter.next() : null;
        if (data == null && instruction == null) {
            return null;
        }
        if (data == null) {
            return instruction.getMinAddress();
        }
        if (instruction == null) {
            return data.getMinAddress();
        }
        Address dataAddr = data.getMinAddress();
        if (dataAddr.compareTo(instructionAddr = instruction.getAddress()) < 0) {
            return dataAddr;
        }
        return instructionAddr;
    }

    public static boolean isUndefinedRange(Program program, Address startAddress, Address endAddress) {
        MemoryBlock block = program.getMemory().getBlock(startAddress);
        if (block == null || !block.contains(endAddress)) {
            return false;
        }
        if (startAddress.compareTo(endAddress) > 0) {
            return false;
        }
        Listing listing = program.getListing();
        Data data = listing.getDataContaining(startAddress);
        if (data == null || !Undefined.isUndefined(data.getDataType())) {
            return false;
        }
        Address maxAddress = data.getMaxAddress();
        while (maxAddress.compareTo(endAddress) < 0) {
            CodeUnit codeUnit = listing.getDefinedCodeUnitAfter(maxAddress);
            if (codeUnit == null) {
                return true;
            }
            Address minAddress = codeUnit.getMinAddress();
            if (minAddress.compareTo(endAddress) > 0) {
                return true;
            }
            if (!(codeUnit instanceof Data) || !Undefined.isUndefined(((Data)codeUnit).getDataType())) {
                return false;
            }
            maxAddress = codeUnit.getMaxAddress();
        }
        return true;
    }

    public static enum ClearDataMode {
        CHECK_FOR_SPACE,
        CLEAR_SINGLE_DATA,
        CLEAR_ALL_UNDEFINED_CONFLICT_DATA,
        CLEAR_ALL_CONFLICT_DATA;

    }
}

