/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import java.util.StringTokenizer;

public class CategoryPath
implements Comparable<CategoryPath> {
    public static final char DELIMITER_CHAR = '/';
    public static final String DELIMITER_STRING = "/";
    public static final CategoryPath ROOT = new CategoryPath(null);
    private static final String ILLEGAL_STRING = "//";
    private final String parentPath;
    private final String name;

    public CategoryPath(String path) {
        if (path == null || path.length() == 0 || path.equals(DELIMITER_STRING)) {
            this.name = "";
            this.parentPath = "";
        } else {
            if (path.charAt(0) != '/') {
                throw new IllegalArgumentException("Paths must start with /");
            }
            if (path.charAt(path.length() - 1) == '/') {
                throw new IllegalArgumentException("Paths must not end with /");
            }
            if (path.indexOf(ILLEGAL_STRING) >= 0) {
                throw new IllegalArgumentException("Paths must have non-empty elements");
            }
            int index = path.lastIndexOf(47);
            this.parentPath = path.substring(0, index);
            this.name = path.substring(index + 1);
        }
    }

    public CategoryPath(CategoryPath parent, String name) {
        if (name == null || name.length() == 0 || name.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Bad name: " + name);
        }
        this.parentPath = parent.isRoot() ? "" : parent.getPath();
        this.name = name;
    }

    public boolean isRoot() {
        return this.parentPath.length() == 0 && this.name.length() == 0;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.parentPath + DELIMITER_STRING + this.name;
    }

    public CategoryPath getParent() {
        if (this.parentPath.length() == 0 && this.name.length() == 0) {
            return null;
        }
        return new CategoryPath(this.parentPath);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CategoryPath) {
            CategoryPath cp = (CategoryPath)obj;
            return cp.parentPath.equals(this.parentPath) && cp.name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.parentPath.hashCode() + this.name.hashCode();
    }

    public boolean isAncestorOrSelf(CategoryPath categoryPath) {
        if (categoryPath.isRoot()) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        String otherCategory = categoryPath.getPath();
        String myCategory = this.getPath();
        if (!myCategory.startsWith(otherCategory)) {
            return false;
        }
        if (myCategory.length() == otherCategory.length()) {
            return true;
        }
        return myCategory.charAt(otherCategory.length()) == '/';
    }

    public String[] getPathElements() {
        StringTokenizer tokenizer = new StringTokenizer(this.getPath(), DELIMITER_STRING);
        String[] tokens = new String[tokenizer.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokenizer.nextToken();
        }
        return tokens;
    }

    @Override
    public int compareTo(CategoryPath otherPath) {
        return this.getPath().compareTo(otherPath.getPath());
    }

    public String toString() {
        return this.getPath();
    }
}

