/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.GenericAddress;
import ghidra.program.model.address.SegmentedAddressSpace;

public class SegmentedAddress
extends GenericAddress {
    private static final long serialVersionUID = 0L;
    public static final int OFFSET_SIZE = 16;
    public static final int SEGMENT_SIZE = 16;
    private final SegmentedAddressSpace addrSpace;
    private final int segment;

    SegmentedAddress(long offset, SegmentedAddressSpace addrSpace) {
        super(SegmentedAddress.adjustOffset(offset), addrSpace);
        this.addrSpace = addrSpace;
        this.segment = offset > 1048575L ? 65535 : (int)(offset >> 4 & 0xF000L);
    }

    SegmentedAddress(SegmentedAddressSpace addrSpace, int segment, int segmentOffset) throws AddressOutOfBoundsException {
        super(addrSpace, (segment << 4) + segmentOffset);
        this.addrSpace = addrSpace;
        this.segment = this.offset > 1048575L ? 65535 : segment;
    }

    SegmentedAddress(SegmentedAddressSpace addrSpace, long offset) throws AddressOutOfBoundsException {
        super(addrSpace, SegmentedAddress.adjustOffset(offset));
        this.addrSpace = addrSpace;
        this.segment = offset > 1048575L ? 65535 : (int)(offset >> 4 & 0xF000L);
    }

    private static long adjustOffset(long offset) {
        if (offset == 0xFFFFFFFFL) {
            offset = 1048575L;
        }
        return offset;
    }

    public int getSegment() {
        return this.segment;
    }

    public int getSegmentOffset() {
        return (int)(this.offset - (long)(this.segment << 4));
    }

    public SegmentedAddress normalize(int seg) {
        if ((long)(seg << 4) > this.offset) {
            return this;
        }
        int off = (int)(this.offset - (long)(seg << 4));
        if (off > 65535) {
            return this;
        }
        return new SegmentedAddress(this.addrSpace, seg, off);
    }

    @Override
    public Address getNewAddress(long byteOffset) {
        SegmentedAddress segAddr = this.addrSpace.getAddress(byteOffset);
        return segAddr.normalize(this.segment);
    }

    @Override
    public Address getNewAddress(long addrOffset, boolean isAddressableWordOffset) throws AddressOutOfBoundsException {
        return this.getNewAddress(addrOffset);
    }

    @Override
    public Address getNewTruncatedAddress(long addrOffset, boolean isAddressableWordOffset) throws AddressOutOfBoundsException {
        return this.getNewAddress(this.addrSpace.truncateOffset(addrOffset));
    }

    private String getString(long value) {
        String str = Long.toHexString(value);
        return "0000000000000000".substring(0, 4 - str.length()) + str;
    }

    @Override
    public String toString(String prefix) {
        return prefix + this.getString(this.segment) + ":" + this.getString(this.getSegmentOffset());
    }

    @Override
    public Address getPhysicalAddress() {
        return this;
    }

    @Override
    public String toString(boolean showAddressSpace, int minNumDigits) {
        String addr = this.getString(this.segment) + ":" + this.getString(this.getSegmentOffset());
        if (showAddressSpace) {
            addr = this.addrSpace.getName() + ":" + addr;
        }
        return addr;
    }
}

