/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBFieldIterator;
import db.DBHandle;
import db.DBLongIterator;
import db.Field;
import db.KeyToRecordIterator;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressIndexKeyIterator;
import ghidra.program.database.map.AddressIndexPrimaryKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressRecordDeleter;
import ghidra.program.database.symbol.SymbolDatabaseAdapter;
import ghidra.program.database.symbol.SymbolDatabaseAdapterV0;
import ghidra.program.database.util.DatabaseTableUtils;
import ghidra.program.database.util.RecordFilter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

class SymbolDatabaseAdapterV2
extends SymbolDatabaseAdapter {
    private static final int SYMBOL_VERSION = 2;
    private Table symbolTable;
    private AddressMap addrMap;

    SymbolDatabaseAdapterV2(DBHandle handle, AddressMap addrMap, boolean create) throws VersionException, IOException {
        this.addrMap = addrMap;
        if (create) {
            this.symbolTable = handle.createTable("Symbols", SYMBOL_SCHEMA, new int[]{1, 0, 2});
        } else {
            this.symbolTable = handle.getTable("Symbols");
            if (this.symbolTable == null) {
                throw new VersionException("Missing Table: Symbols");
            }
            if (this.symbolTable.getSchema().getVersion() != 2) {
                int version = this.symbolTable.getSchema().getVersion();
                if (version < 2) {
                    throw new VersionException(true);
                }
                throw new VersionException(2, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SymbolDatabaseAdapter upgrade(DBHandle dbHandle, AddressMap addrMap, SymbolDatabaseAdapter oldAdapter, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        AddressMap oldAddrMap = addrMap.getOldAddressMap();
        DBHandle tmpHandle = dbHandle.getScratchPad();
        long nextKey = 1L;
        try {
            if (oldAdapter instanceof SymbolDatabaseAdapterV0) {
                nextKey = ((SymbolDatabaseAdapterV0)oldAdapter).extractLocalSymbols(tmpHandle, monitor);
            }
            monitor.setMessage("Upgrading Symbol Table...");
            monitor.initialize((long)(oldAdapter.getSymbolCount() * 2));
            int count = 0;
            SymbolDatabaseAdapterV2 tmpAdapter = new SymbolDatabaseAdapterV2(tmpHandle, addrMap, true);
            RecordIterator iter = oldAdapter.getSymbols();
            Record zeroRecord = null;
            while (iter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                Record rec = iter.next();
                Address addr = oldAddrMap.decodeAddress(rec.getLongValue(1));
                rec.setLongValue(1, addrMap.getKey(addr, true));
                if (rec.getKey() == 0L) {
                    zeroRecord = rec;
                } else {
                    tmpAdapter.symbolTable.putRecord(rec);
                }
                monitor.setProgress((long)(++count));
            }
            if (zeroRecord != null) {
                tmpAdapter.createSymbol(Math.max(1L, nextKey), zeroRecord);
            }
            dbHandle.deleteTable("Symbols");
            SymbolDatabaseAdapterV2 newAdapter = new SymbolDatabaseAdapterV2(dbHandle, addrMap, true);
            iter = tmpAdapter.getSymbols();
            while (iter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                Record rec = iter.next();
                String name = rec.getString(0);
                if (SymbolUtilities.startsWithDefaultDynamicPrefix(name)) {
                    rec.setString(0, SymbolDatabaseAdapterV2.fixSymbolName(tmpAdapter, name, rec.getLongValue(2)));
                }
                newAdapter.symbolTable.putRecord(rec);
                monitor.setProgress((long)(++count));
            }
            SymbolDatabaseAdapterV2 symbolDatabaseAdapterV2 = newAdapter;
            return symbolDatabaseAdapterV2;
        }
        finally {
            tmpHandle.deleteTable("Symbols");
        }
    }

    private void createSymbol(long nextKey, Record zeroRecord) throws IOException {
        zeroRecord.setKey(nextKey);
        this.symbolTable.putRecord(zeroRecord);
    }

    private static String fixSymbolName(SymbolDatabaseAdapter tmpAdapter, String name, long namespaceId) throws IOException {
        String baseName;
        String newName = baseName = "_" + name;
        int cnt = 0;
        while (true) {
            try {
                RecordIterator iter = tmpAdapter.getSymbolsByName(newName);
                while (iter.hasNext()) {
                    Record otherRec = iter.next();
                    if (namespaceId != otherRec.getLongValue(2)) continue;
                    throw new DuplicateNameException();
                }
                return newName;
            }
            catch (DuplicateNameException e) {
                newName = baseName + "_" + ++cnt;
                continue;
            }
            break;
        }
    }

    @Override
    Record createSymbol(String name, Address address, long namespaceID, SymbolType symbolType, long data1, int data2, String data3, SourceType source) throws IOException {
        long nextID = this.symbolTable.getKey();
        if (nextID == 0L) {
            ++nextID;
        }
        return this.createSymbol(nextID, name, address, namespaceID, symbolType, data1, data2, data3, (byte)source.ordinal());
    }

    private Record createSymbol(long id, String name, Address address, long namespaceID, SymbolType symbolType, long data1, int data2, String data3, byte flags) throws IOException {
        Record rec = this.symbolTable.getSchema().createRecord(id);
        rec.setString(0, name);
        rec.setLongValue(1, this.addrMap.getKey(address, true));
        rec.setLongValue(2, namespaceID);
        rec.setByteValue(3, symbolType.getID());
        rec.setLongValue(4, data1);
        rec.setIntValue(5, data2);
        rec.setString(6, data3);
        rec.setByteValue(7, flags);
        this.symbolTable.putRecord(rec);
        return rec;
    }

    @Override
    void removeSymbol(long symbolID) throws IOException {
        this.symbolTable.deleteRecord(symbolID);
    }

    @Override
    boolean hasSymbol(Address addr) throws IOException {
        long key = this.addrMap.getKey(addr, false);
        if (key == -1L && !addr.equals(Address.NO_ADDRESS)) {
            return false;
        }
        return this.symbolTable.hasRecord((Field)new LongField(key), 1);
    }

    @Override
    long[] getSymbolIDs(Address addr) throws IOException {
        long key = this.addrMap.getKey(addr, false);
        if (key == -1L && !addr.equals(Address.NO_ADDRESS)) {
            return new long[0];
        }
        return this.symbolTable.findRecords((Field)new LongField(key), 1);
    }

    @Override
    Record getSymbolRecord(long symbolID) throws IOException {
        return this.symbolTable.getRecord(symbolID);
    }

    @Override
    int getSymbolCount() {
        return this.symbolTable.getRecordCount();
    }

    @Override
    RecordIterator getSymbolsByAddress(boolean forward) throws IOException {
        return new KeyToRecordIterator(this.symbolTable, (DBLongIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, forward));
    }

    @Override
    RecordIterator getSymbolsByAddress(Address startAddr, boolean forward) throws IOException {
        return new KeyToRecordIterator(this.symbolTable, (DBLongIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, startAddr, forward));
    }

    @Override
    void updateSymbolRecord(Record record) throws IOException {
        this.symbolTable.putRecord(record);
    }

    @Override
    RecordIterator getSymbols() throws IOException {
        return this.symbolTable.iterator();
    }

    @Override
    RecordIterator getSymbols(Address start, Address end, boolean forward) throws IOException {
        return new KeyToRecordIterator(this.symbolTable, (DBLongIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, start, end, forward));
    }

    void deleteExternalEntries(Address start, Address end) throws IOException {
        AddressRecordDeleter.deleteRecords(this.symbolTable, 1, this.addrMap, start, end, null);
    }

    @Override
    void moveAddress(Address oldAddr, Address newAddr) throws IOException {
        long[] keys;
        LongField oldKey = new LongField(this.addrMap.getKey(oldAddr, false));
        long newKey = this.addrMap.getKey(newAddr, true);
        for (long key : keys = this.symbolTable.findRecords((Field)oldKey, 1)) {
            Record rec = this.symbolTable.getRecord(key);
            rec.setLongValue(1, newKey);
            this.symbolTable.putRecord(rec);
        }
    }

    @Override
    void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException, IOException {
        DatabaseTableUtils.updateIndexedAddressField(this.symbolTable, 1, this.addrMap, fromAddr, toAddr, length, null, monitor);
    }

    @Override
    Set<Address> deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException, IOException {
        AnchoredSymbolRecordFilter filter = new AnchoredSymbolRecordFilter();
        AddressRecordDeleter.deleteRecords(this.symbolTable, 1, this.addrMap, startAddr, endAddr, filter);
        return filter.getAddressesForSkippedRecords();
    }

    @Override
    RecordIterator getSymbolsByNamespace(long id) throws IOException {
        LongField field = new LongField(id);
        return this.symbolTable.indexIterator(2, (Field)field, (Field)field, true);
    }

    @Override
    RecordIterator getSymbolsByName(String name) throws IOException {
        StringField field = new StringField(name);
        return this.symbolTable.indexIterator(0, (Field)field, (Field)field, true);
    }

    @Override
    Address getMaxSymbolAddress(AddressSpace space) throws IOException {
        if (space.isMemorySpace()) {
            AddressIndexKeyIterator addressKeyIterator = new AddressIndexKeyIterator(this.symbolTable, 1, this.addrMap, space.getMinAddress(), space.getMaxAddress(), false);
            if (addressKeyIterator.hasNext()) {
                return this.addrMap.decodeAddress(addressKeyIterator.next());
            }
        } else {
            LongField val;
            Address addr;
            LongField max = new LongField(this.addrMap.getKey(space.getMaxAddress(), false));
            DBFieldIterator iterator = this.symbolTable.indexFieldIterator(null, (Field)max, false, 1);
            if (iterator.hasPrevious() && space.equals((addr = this.addrMap.decodeAddress((val = (LongField)iterator.previous()).getLongValue())).getAddressSpace())) {
                return addr;
            }
        }
        return null;
    }

    @Override
    Table getTable() {
        return this.symbolTable;
    }

    class AnchoredSymbolRecordFilter
    implements RecordFilter {
        private Set<Address> set = new HashSet<Address>();

        AnchoredSymbolRecordFilter() {
        }

        @Override
        public boolean matches(Record record) {
            Address addr = SymbolDatabaseAdapterV2.this.addrMap.decodeAddress(record.getLongValue(1));
            byte flags = record.getByteValue(7);
            if ((flags & 4) == 0) {
                return true;
            }
            this.set.add(addr);
            return false;
        }

        Set<Address> getAddressesForSkippedRecords() {
            return this.set;
        }
    }
}

