/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.oldfunction;

import db.DBHandle;
import db.Field;
import db.IntField;
import db.LongField;
import db.Record;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.oldfunction.OldStackVariableDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class OldStackVariableDBAdapterV0
extends OldStackVariableDBAdapter {
    static final String STACK_VARS_TABLE_NAME = "Stack Variables";
    static final int SCHEMA_VERSION = 0;
    static final int V0_STACK_VAR_FUNCTION_KEY_COL = 0;
    static final int V0_STACK_VAR_OFFSET_COL = 1;
    static final int V0_STACK_VAR_DATA_TYPE_ID_COL = 2;
    static final int V0_STACK_VAR_NAME_COL = 3;
    static final int V0_STACK_VAR_COMMENT_COL = 4;
    static final Schema V0_STACK_VARS_SCHEMA = new Schema(0, "Key", new Class[]{LongField.class, IntField.class, LongField.class, StringField.class, StringField.class}, new String[]{"Function ID", "Offset", "DataType ID", "Name", "Comment"});
    private Table table;

    OldStackVariableDBAdapterV0(DBHandle dbHandle, AddressMap addrMap) throws VersionException {
        this.table = dbHandle.getTable(STACK_VARS_TABLE_NAME);
        if (this.table == null) {
            throw new VersionException("Missing Table: Stack Variables");
        }
        if (this.table.getSchema().getVersion() != 0) {
            throw new VersionException("Expected version 0 for table Stack Variables but got " + this.table.getSchema().getVersion());
        }
    }

    @Override
    public Record getStackVariableRecord(long key) throws IOException {
        return this.translateRecord(this.table.getRecord(key));
    }

    @Override
    public long[] getStackVariableKeys(long functionKey) throws IOException {
        return this.table.findRecords((Field)new LongField(functionKey), 0);
    }

    private Record translateRecord(Record oldRec) {
        if (oldRec == null) {
            return null;
        }
        Record rec = OldStackVariableDBAdapter.STACK_VARS_SCHEMA.createRecord(oldRec.getKey());
        rec.setLongValue(0, oldRec.getLongValue(0));
        rec.setString(3, oldRec.getString(3));
        rec.setLongValue(2, oldRec.getLongValue(2));
        rec.setIntValue(1, oldRec.getIntValue(1));
        rec.setString(4, oldRec.getString(4));
        rec.setIntValue(5, 1);
        return rec;
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable(STACK_VARS_TABLE_NAME);
    }
}

