/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.module;

import db.Record;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.module.FragmentDB;
import ghidra.program.database.module.GroupDBAdapter;
import ghidra.program.database.module.ModuleManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.DuplicateGroupException;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.Lock;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class ModuleDB
extends DatabaseObject
implements ProgramModule {
    private Record record;
    private ModuleManager moduleMgr;
    private GroupDBAdapter adapter;
    private int childCount;
    private Lock lock;

    ModuleDB(ModuleManager moduleMgr, DBObjectCache<ModuleDB> cache, Record record) {
        super(cache, record.getKey());
        this.moduleMgr = moduleMgr;
        this.record = record;
        this.adapter = moduleMgr.getGroupDBAdapter();
        this.updateChildCount();
        this.lock = moduleMgr.getLock();
    }

    @Override
    protected boolean refresh() {
        block4: {
            try {
                Record rec = this.adapter.getModuleRecord(this.key);
                if (rec == null) break block4;
                this.record = rec;
                this.childCount = 0;
                try {
                    long[] keys = this.adapter.getParentChildKeys(this.key, 0);
                    this.childCount = keys.length;
                }
                catch (IOException e) {
                    this.moduleMgr.dbError(e);
                }
                return true;
            }
            catch (IOException e) {
                this.moduleMgr.dbError(e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ProgramFragment fragment) throws DuplicateGroupException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            FragmentDB frag = (FragmentDB)fragment;
            long fragID = frag.getKey();
            Record parentChildRecord = this.adapter.getParentChildRecord(this.key, -fragID);
            if (parentChildRecord != null) {
                throw new DuplicateGroupException(frag.getName() + " already exists a child of " + this.getName());
            }
            Record pcRec = this.adapter.addParentChildRecord(this.key, -fragID);
            this.updateChildCount();
            this.updateOrderField(pcRec);
            this.moduleMgr.fragmentAdded(this.key, frag);
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ProgramModule module) throws CircularDependencyException, DuplicateGroupException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            ModuleDB moduleDB = (ModuleDB)module;
            long moduleID = moduleDB.getKey();
            Record parentChildRecord = this.adapter.getParentChildRecord(this.key, moduleID);
            if (parentChildRecord != null) {
                throw new DuplicateGroupException(module.getName() + " already exists a child of " + this.getName());
            }
            if (this.moduleMgr.isDescendant(this.key, moduleID)) {
                throw new CircularDependencyException(this.getName() + " is already a descendant of " + module.getName());
            }
            Record pcRec = this.adapter.addParentChildRecord(this.key, moduleID);
            this.updateChildCount();
            this.updateOrderField(pcRec);
            this.moduleMgr.moduleAdded(this.key, module);
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean contains(ProgramFragment fragment) {
        if (!(fragment instanceof FragmentDB)) {
            return false;
        }
        FragmentDB frag = (FragmentDB)fragment;
        if (this.moduleMgr != frag.getModuleManager()) {
            return false;
        }
        return this.contains(-frag.getKey());
    }

    @Override
    public boolean contains(ProgramModule module) {
        if (!(module instanceof ModuleDB)) {
            return false;
        }
        ModuleDB moduleDB = (ModuleDB)module;
        if (this.moduleMgr != moduleDB.moduleMgr) {
            return false;
        }
        return this.contains(moduleDB.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgramFragment createFragment(String fragmentName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            Record parentChildRecord = this.adapter.createFragment(this.key, fragmentName);
            FragmentDB frag = this.moduleMgr.getFragmentDB(parentChildRecord);
            Record pcRec = this.adapter.getParentChildRecord(this.key, -frag.getKey());
            this.updateChildCount();
            this.updateOrderField(pcRec);
            this.moduleMgr.fragmentAdded(this.key, frag);
            FragmentDB fragmentDB = frag;
            return fragmentDB;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgramModule createModule(String moduleName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            Record moduleRecord = this.adapter.createModule(this.key, moduleName);
            ModuleDB moduleDB = this.moduleMgr.getModuleDB(moduleRecord);
            Record pcRec = this.adapter.getParentChildRecord(this.key, moduleDB.key);
            this.updateChildCount();
            this.updateOrderField(pcRec);
            this.moduleMgr.moduleAdded(this.key, moduleDB);
            ModuleDB moduleDB2 = moduleDB;
            return moduleDB2;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group[] getChildren() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            List<Record> list = this.getParentChildRecords();
            Group[] kids = new Group[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Record rec = list.get(i);
                long childID = rec.getLongValue(1);
                kids[i] = childID < 0L ? this.moduleMgr.getFragmentDB(-childID) : this.moduleMgr.getModuleDB(childID);
            }
            this.childCount = kids.length;
            Group[] groupArray = kids;
            return groupArray;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return new Group[0];
    }

    @Override
    public String getComment() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.record.getString(1);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Address getFirstAddress() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Address address = this.findFirstAddress(this);
            return address;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIndex(String name) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Record fragmentRecord = this.adapter.getFragmentRecord(name);
            Record pcRec = null;
            if (fragmentRecord != null) {
                long fragID = fragmentRecord.getKey();
                pcRec = this.adapter.getParentChildRecord(this.key, -fragID);
            } else {
                fragmentRecord = this.adapter.getModuleRecord(name);
                if (fragmentRecord != null) {
                    pcRec = this.adapter.getParentChildRecord(this.key, fragmentRecord.getKey());
                }
            }
            if (pcRec != null) {
                int n = pcRec.getIntValue(2);
                return n;
            }
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return -1;
    }

    @Override
    public Address getLastAddress() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Address address = this.findLastAddress(this);
            return address;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Address getMaxAddress() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Address address = this.findMaxAddress(this, null);
            return address;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Address getMinAddress() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Address address = this.findMinAddress(this, null);
            return address;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressSetView getAddressSet() {
        AddressSet set = new AddressSet();
        Group[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof ProgramFragment) {
                set.add((ProgramFragment)children[i]);
                continue;
            }
            ProgramModule m = (ProgramModule)children[i];
            set.add(m.getAddressSet());
        }
        return set;
    }

    @Override
    public int getNumChildren() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int n = this.childCount;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isDescendant(ProgramFragment fragment) {
        if (!(fragment instanceof FragmentDB)) {
            return false;
        }
        FragmentDB frag = (FragmentDB)fragment;
        try {
            return this.moduleMgr.isDescendant(-frag.getKey(), this.key);
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
            return false;
        }
    }

    @Override
    public boolean isDescendant(ProgramModule module) {
        if (!(module instanceof ModuleDB)) {
            return false;
        }
        ModuleDB moduleDB = (ModuleDB)module;
        try {
            return this.moduleMgr.isDescendant(moduleDB.key, this.key);
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveChild(String name, int index) throws NotFoundException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            int currentIndex = 0;
            boolean foundName = false;
            DatabaseObject group = null;
            List<Record> list = this.getParentChildRecords();
            for (int i = 0; i < list.size(); ++i) {
                Record rec = list.get(i);
                long childID = rec.getLongValue(1);
                String childName = null;
                Record childRec = null;
                if (childID < 0L) {
                    childRec = this.adapter.getFragmentRecord(-childID);
                    childName = childRec.getString(0);
                } else {
                    childRec = this.adapter.getModuleRecord(childID);
                    childName = childRec.getString(0);
                }
                if (!childName.equals(name)) continue;
                foundName = true;
                currentIndex = i;
                group = childID < 0L ? this.moduleMgr.getFragmentDB(childRec) : this.moduleMgr.getModuleDB(childRec);
            }
            if (!foundName) {
                throw new NotFoundException(name + " is not a child of " + this.getName());
            }
            Record pcRec = list.remove(currentIndex);
            list.add(index, pcRec);
            this.updateChildOrder(list);
            this.moduleMgr.childReordered(this, (Group)((Object)group));
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeChild(String name) throws NotEmptyException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            Record rec = this.adapter.getFragmentRecord(name);
            boolean deleteChild = false;
            if (rec != null) {
                long childID = rec.getKey();
                Record pcRec = this.adapter.getParentChildRecord(this.key, -childID);
                if (pcRec == null) {
                    boolean bl = this.removeModuleRecord(name);
                    return bl;
                }
                long[] keys = this.adapter.getParentChildKeys(-childID, 1);
                if (keys.length == 1) {
                    FragmentDB frag = this.moduleMgr.getFragmentDB(childID);
                    if (!frag.isEmpty()) {
                        throw new NotEmptyException(frag.getName() + " is not empty");
                    }
                    deleteChild = true;
                }
                boolean bl = this.removeChild(childID, pcRec, true, deleteChild);
                return bl;
            }
            boolean bl = this.removeModuleRecord(name);
            return bl;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    private boolean removeModuleRecord(String name) throws IOException, NotEmptyException {
        Record rec = this.adapter.getModuleRecord(name);
        if (rec == null) {
            return false;
        }
        boolean deleteChild = false;
        long childID = rec.getKey();
        Record pcRec = this.adapter.getParentChildRecord(this.key, childID);
        if (pcRec == null) {
            return false;
        }
        long[] keys = this.adapter.getParentChildKeys(childID, 1);
        if (keys.length == 1) {
            ModuleDB module = this.moduleMgr.getModuleDB(childID);
            if (module.getNumChildren() > 0) {
                throw new NotEmptyException(this.getName() + " is not empty");
            }
            deleteChild = true;
        }
        return this.removeChild(childID, pcRec, false, deleteChild);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reparent(String name, ProgramModule oldParent) throws NotFoundException {
        Group group = null;
        ProgramFragment f = null;
        this.lock.acquire();
        try {
            long childID;
            this.checkDeleted();
            ProgramModule m = this.moduleMgr.getModule(name);
            if (m == null) {
                f = this.moduleMgr.getFragment(name);
                if (f == null) {
                    throw new NotFoundException(name + " was not found as child of " + this.getName());
                }
                childID = -((FragmentDB)f).getKey();
                group = f;
            } else {
                childID = ((ModuleDB)m).key;
                group = m;
            }
            ModuleDB oldModuleDB = (ModuleDB)oldParent;
            Record oldPcRec = this.adapter.getParentChildRecord(oldModuleDB.key, childID);
            this.adapter.removeParentChildRecord(oldPcRec.getKey());
            Record newPcRec = this.adapter.addParentChildRecord(this.key, childID);
            ++this.childCount;
            this.updateOrderField(newPcRec);
            oldModuleDB.resetChildOrder();
            this.moduleMgr.childReparented(group, oldParent.getName(), this.getName());
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean contains(CodeUnit codeUnit) {
        FragmentDB frag = this.moduleMgr.getFragment(codeUnit);
        if (frag != null) {
            return this.contains(frag);
        }
        return false;
    }

    @Override
    public String getName() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.record.getString(0);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumParents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            long[] keys = this.adapter.getParentChildKeys(this.key, 1);
            int n = keys.length;
            return n;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return 0;
    }

    @Override
    public String[] getParentNames() {
        return this.moduleMgr.getParentNames(this.key);
    }

    @Override
    public ProgramModule[] getParents() {
        return this.moduleMgr.getParents(this.key);
    }

    @Override
    public String getTreeName() {
        return this.moduleMgr.getTreeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setComment(String comment) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            String oldComments = this.record.getString(1);
            if (oldComments == null || !oldComments.equals(comment)) {
                this.record.setString(1, comment);
                try {
                    this.adapter.updateModuleRecord(this.record);
                    this.moduleMgr.commentsChanged(oldComments, this);
                }
                catch (IOException e) {
                    this.moduleMgr.dbError(e);
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String name) throws DuplicateNameException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.key == ModuleManager.ROOT_MODULE_ID) {
                this.moduleMgr.getProgram().setName(name);
                return;
            }
            Record r = this.adapter.getModuleRecord(name);
            if (r != null) {
                if (this.key != r.getKey()) {
                    throw new DuplicateNameException(name + " already exists");
                }
                return;
            }
            if (this.adapter.getFragmentRecord(name) != null) {
                throw new DuplicateNameException(name + " already exists");
            }
            String oldName = this.record.getString(0);
            this.record.setString(0, name);
            this.adapter.updateModuleRecord(this.record);
            this.moduleMgr.nameChanged(oldName, this);
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    Record getRecord() {
        return this.record;
    }

    private boolean contains(long childID) {
        try {
            Record rec = this.adapter.getParentChildRecord(this.key, childID);
            return rec != null;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
            return false;
        }
    }

    private boolean removeChild(long childID, Record pcRec, boolean isFragment, boolean deleteChild) throws IOException {
        this.adapter.removeParentChildRecord(pcRec.getKey());
        String name = null;
        boolean success = true;
        if (isFragment) {
            Record fragRec = this.adapter.getFragmentRecord(childID);
            name = fragRec.getString(0);
            if (deleteChild) {
                success = this.adapter.removeFragmentRecord(childID);
            }
        } else {
            Record mrec = this.adapter.getModuleRecord(childID);
            name = mrec.getString(0);
            if (deleteChild) {
                success = this.adapter.removeModuleRecord(childID);
            }
        }
        if (success) {
            this.resetChildOrder();
            this.moduleMgr.groupRemoved(this, childID, name, isFragment, deleteChild);
        }
        return success;
    }

    private List<Record> getParentChildRecords() throws IOException {
        long[] keys = this.adapter.getParentChildKeys(this.key, 0);
        ArrayList<Record> list = new ArrayList<Record>();
        ParentChildRecordComparator c = new ParentChildRecordComparator();
        for (int i = 0; i < keys.length; ++i) {
            Record rec = this.adapter.getParentChildRecord(keys[i]);
            int index = Collections.binarySearch(list, rec, c);
            if (index < 0) {
                index = -index - 1;
            }
            list.add(index, rec);
        }
        return list;
    }

    private void updateChildOrder(List<Record> list) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            Record pcRec = list.get(i);
            pcRec.setIntValue(2, i);
            this.adapter.updateParentChildRecord(pcRec);
        }
    }

    private void resetChildOrder() throws IOException {
        List<Record> list = this.getParentChildRecords();
        this.updateChildOrder(list);
        this.updateChildCount();
    }

    private void updateOrderField(Record pcRec) throws IOException {
        int orderValue = this.getNumChildren() - 1;
        if (orderValue < 0) {
            orderValue = 0;
        }
        pcRec.setIntValue(2, orderValue);
        this.adapter.updateParentChildRecord(pcRec);
    }

    private Address findFirstAddress(ModuleDB module) {
        try {
            List<Record> list = module.getParentChildRecords();
            for (int i = 0; i < list.size(); ++i) {
                Record rec = list.get(i);
                long childID = rec.getLongValue(1);
                if (childID < 0L) {
                    FragmentDB frag = this.moduleMgr.getFragmentDB(-childID);
                    if (frag.isEmpty()) continue;
                    return frag.getMinAddress();
                }
                ModuleDB m = this.moduleMgr.getModuleDB(childID);
                Address addr = this.findFirstAddress(m);
                if (addr == null) continue;
                return addr;
            }
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        return null;
    }

    private Address findLastAddress(ModuleDB module) {
        try {
            List<Record> list = module.getParentChildRecords();
            for (int i = list.size() - 1; i >= 0; --i) {
                Record rec = list.get(i);
                long childID = rec.getLongValue(1);
                if (childID < 0L) {
                    FragmentDB frag = this.moduleMgr.getFragmentDB(-childID);
                    if (frag.isEmpty()) continue;
                    return frag.getMaxAddress();
                }
                ModuleDB m = this.moduleMgr.getModuleDB(childID);
                Address addr = this.findLastAddress(m);
                if (addr == null) continue;
                return addr;
            }
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        return null;
    }

    private Address findMinAddress(ModuleDB module, Address addr) {
        Address minAddr = addr;
        try {
            List<Record> list = module.getParentChildRecords();
            for (int i = 0; i < list.size(); ++i) {
                Record rec = list.get(i);
                long childID = rec.getLongValue(1);
                Address childMinAddr = null;
                if (childID < 0L) {
                    FragmentDB frag = this.moduleMgr.getFragmentDB(-childID);
                    if (!frag.isEmpty()) {
                        childMinAddr = frag.getMinAddress();
                    }
                } else {
                    ModuleDB m = this.moduleMgr.getModuleDB(childID);
                    childMinAddr = this.findMinAddress(m, addr);
                }
                if (childMinAddr != null && minAddr == null) {
                    minAddr = childMinAddr;
                    continue;
                }
                if (childMinAddr == null || childMinAddr.compareTo(minAddr) >= 0) continue;
                minAddr = childMinAddr;
            }
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        return minAddr;
    }

    private Address findMaxAddress(ModuleDB module, Address addr) {
        Address maxAddr = addr;
        try {
            List<Record> list = module.getParentChildRecords();
            for (int i = 0; i < list.size(); ++i) {
                Record rec = list.get(i);
                long childID = rec.getLongValue(1);
                Address childMaxAddr = null;
                if (childID < 0L) {
                    FragmentDB frag = this.moduleMgr.getFragmentDB(-childID);
                    if (!frag.isEmpty()) {
                        childMaxAddr = frag.getMaxAddress();
                    }
                } else {
                    ModuleDB m = this.moduleMgr.getModuleDB(childID);
                    childMaxAddr = this.findMaxAddress(m, addr);
                }
                if (childMaxAddr != null && maxAddr == null) {
                    maxAddr = childMaxAddr;
                    continue;
                }
                if (childMaxAddr == null || childMaxAddr.compareTo(maxAddr) <= 0) continue;
                maxAddr = childMaxAddr;
            }
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        return maxAddr;
    }

    private void updateChildCount() {
        this.checkIsValid();
        this.childCount = 0;
        try {
            long[] keys = this.adapter.getParentChildKeys(this.key, 0);
            this.childCount = keys.length;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
    }

    @Override
    public Object getVersionTag() {
        return this.moduleMgr.getVersionTag();
    }

    @Override
    public long getModificationNumber() {
        return this.moduleMgr.getModificationNumber();
    }

    @Override
    public long getTreeID() {
        return this.moduleMgr.getTreeID();
    }

    private class ParentChildRecordComparator
    implements Comparator<Record> {
        private ParentChildRecordComparator() {
        }

        @Override
        public int compare(Record r1, Record r2) {
            int index2;
            int index1 = r1.getIntValue(2);
            if (index1 < (index2 = r2.getIntValue(2))) {
                return -1;
            }
            if (index1 > index2) {
                return 1;
            }
            return 0;
        }
    }
}

