/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.BooleanField;
import db.DBHandle;
import db.Field;
import db.IntField;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.RecordTranslator;
import db.Schema;
import db.StringField;
import db.Table;
import db.TranslatedRecordIterator;
import ghidra.program.database.data.CompositeDBAdapter;
import ghidra.util.UniversalID;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class CompositeDBAdapterV0
extends CompositeDBAdapter
implements RecordTranslator {
    static final int VERSION = 0;
    static final int V0_COMPOSITE_NAME_COL = 0;
    static final int V0_COMPOSITE_COMMENT_COL = 1;
    static final int V0_COMPOSITE_IS_UNION_COL = 2;
    static final int V0_COMPOSITE_CAT_COL = 3;
    static final int V0_COMPOSITE_LENGTH_COL = 4;
    static final int V0_COMPOSITE_NUM_COMPONENTS_COL = 5;
    static final Schema V0_COMPOSITE_SCHEMA = new Schema(0, "Data Type ID", new Class[]{StringField.class, StringField.class, BooleanField.class, LongField.class, IntField.class, IntField.class}, new String[]{"Name", "Comment", "Is Union", "Category ID", "Length", "Number Of Components"});
    private Table compositeTable;

    public CompositeDBAdapterV0(DBHandle handle) throws VersionException {
        this.compositeTable = handle.getTable("Composite Data Types");
        if (this.compositeTable == null) {
            throw new VersionException("Missing Table: Composite Data Types");
        }
        int version = this.compositeTable.getSchema().getVersion();
        if (version != 0) {
            String msg = "Expected version 0 for table Composite Data Types but got " + this.compositeTable.getSchema().getVersion();
            if (version < 0) {
                throw new VersionException(msg, 1, true);
            }
            throw new VersionException(msg, 2, false);
        }
    }

    @Override
    public Record createRecord(String name, String comments, boolean isUnion, long categoryID, int length, long sourceArchiveID, long sourceDataTypeID, long lastChangeTime, int internalAlignment, int externalAlignment) throws IOException {
        throw new UnsupportedOperationException("Not allowed to update prior version #0 of Composite Data Types table.");
    }

    @Override
    public Record getRecord(long dataTypeID) throws IOException {
        return this.translateRecord(this.compositeTable.getRecord(dataTypeID));
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Composite Data Types");
    }

    @Override
    public void updateRecord(Record record, boolean setLastChangeTime) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRecord(long compositeID) throws IOException {
        return this.compositeTable.deleteRecord(compositeID);
    }

    @Override
    public long[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.compositeTable.findRecords((Field)new LongField(categoryID), 3);
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return new TranslatedRecordIterator(this.compositeTable.iterator(), (RecordTranslator)this);
    }

    @Override
    long[] getRecordIdsForSourceArchive(long archiveID) throws IOException {
        return new long[0];
    }

    public Record translateRecord(Record oldRec) {
        if (oldRec == null) {
            return null;
        }
        Record rec = CompositeDBAdapter.COMPOSITE_SCHEMA.createRecord(oldRec.getKey());
        rec.setString(0, oldRec.getString(0));
        rec.setString(1, oldRec.getString(1));
        rec.setBooleanValue(2, oldRec.getBooleanValue(2));
        rec.setLongValue(3, oldRec.getLongValue(3));
        rec.setIntValue(4, oldRec.getIntValue(4));
        rec.setIntValue(5, oldRec.getIntValue(5));
        rec.setLongValue(6, 0L);
        rec.setLongValue(7, UniversalIdGenerator.nextID().getValue());
        rec.setLongValue(8, 0L);
        rec.setLongValue(9, 0L);
        rec.setIntValue(10, -1);
        rec.setIntValue(11, 0);
        return rec;
    }

    @Override
    Record getRecordWithIDs(UniversalID sourceID, UniversalID datatypeID) throws IOException {
        return null;
    }
}

