/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.bookmark;

import db.DBHandle;
import db.Record;
import db.Schema;
import db.StringField;
import ghidra.program.database.bookmark.BookmarkTypeDBAdapterNoTable;
import ghidra.program.database.bookmark.BookmarkTypeDBAdapterV0;
import ghidra.util.exception.VersionException;
import java.io.IOException;

abstract class BookmarkTypeDBAdapter {
    static final String TABLE_NAME = "Bookmark Types";
    static final int TYPE_NAME_COL = 0;
    static final Schema SCHEMA = new Schema(0, "ID", new Class[]{StringField.class}, new String[]{"Name"});

    BookmarkTypeDBAdapter() {
    }

    static BookmarkTypeDBAdapter getAdapter(DBHandle dbHandle, int openMode) throws VersionException, IOException {
        if (openMode == 0) {
            return new BookmarkTypeDBAdapterV0(dbHandle, true);
        }
        try {
            return new BookmarkTypeDBAdapterV0(dbHandle, false);
        }
        catch (VersionException e) {
            if (openMode == 1) {
                throw e;
            }
            BookmarkTypeDBAdapter adapter = BookmarkTypeDBAdapter.findReadOnlyAdapter(dbHandle);
            if (openMode == 3) {
                adapter = BookmarkTypeDBAdapter.upgrade(dbHandle, adapter);
            }
            return adapter;
        }
    }

    private static BookmarkTypeDBAdapter findReadOnlyAdapter(DBHandle dbHandle) throws VersionException, IOException {
        return new BookmarkTypeDBAdapterNoTable(dbHandle);
    }

    private static BookmarkTypeDBAdapter upgrade(DBHandle dbHandle, BookmarkTypeDBAdapter oldAdapter) throws VersionException, IOException {
        return new BookmarkTypeDBAdapterV0(dbHandle, true);
    }

    void addType(int typeID, String type) throws IOException {
        throw new UnsupportedOperationException("Bookmarks are read-only and may not be added");
    }

    void deleteRecord(long typeId) throws IOException {
        throw new UnsupportedOperationException("Bookmarks are read-only and may not be deleted");
    }

    abstract Record[] getRecords() throws IOException;

    public int[] getTypeIds() throws IOException {
        Record[] typeRecords = this.getRecords();
        int[] ids = new int[typeRecords.length];
        for (int i = 0; i < typeRecords.length; ++i) {
            Record rec = typeRecords[i];
            ids[i] = (int)rec.getKey();
        }
        return ids;
    }
}

