/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.context;

import ghidra.pcodeCPort.address.Address;
import ghidra.pcodeCPort.context.ConstructState;
import ghidra.pcodeCPort.context.FixedHandle;
import ghidra.pcodeCPort.context.ParserContext;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.OperandSymbol;
import ghidra.pcodeCPort.space.AddrSpace;

public class ParserWalker {
    private ParserContext const_context;
    protected ConstructState point;
    protected int depth;
    protected int[] breadcrumb;

    public ParserWalker(ParserContext c) {
        this.const_context = c;
        this.breadcrumb = new int[32];
    }

    public ParserContext getParserContext() {
        return this.const_context;
    }

    public void baseState() {
        this.point = this.const_context.base_state;
        this.depth = 0;
        this.breadcrumb[0] = 0;
    }

    public void setOutOfBandState(Constructor ct, int index, ConstructState tempstate, ParserWalker otherwalker) {
        ConstructState pt = otherwalker.point;
        int curdepth = otherwalker.depth;
        while (pt.ct != ct) {
            if (curdepth <= 0) {
                return;
            }
            --curdepth;
            pt = pt.parent;
        }
        OperandSymbol sym = ct.getOperand(index);
        int i = sym.getOffsetBase();
        tempstate.offset = i < 0 ? pt.offset + sym.getRelativeOffset() : ((ConstructState)pt.resolve.get((int)index)).offset;
        tempstate.ct = ct;
        tempstate.length = pt.length;
        this.point = tempstate;
        this.depth = 0;
        this.breadcrumb[0] = 0;
    }

    public boolean isState() {
        return this.point != null;
    }

    public void pushOperand(int i) {
        this.breadcrumb[this.depth++] = i + 1;
        this.point = (ConstructState)this.point.resolve.get(i);
        this.breadcrumb[this.depth] = 0;
    }

    public void popOperand() {
        this.point = this.point.parent;
        --this.depth;
    }

    public int getOffset(int i) {
        if (i < 0) {
            return this.point.offset;
        }
        ConstructState op = (ConstructState)this.point.resolve.get(i);
        return op.offset + op.length;
    }

    public Constructor getConstructor() {
        return this.point.ct;
    }

    public int getOperand() {
        return this.breadcrumb[this.depth];
    }

    public FixedHandle getParentHandle() {
        return this.point.hand;
    }

    public FixedHandle getFixedHandle(int i) {
        return ((ConstructState)this.point.resolve.get((int)i)).hand;
    }

    public AddrSpace getCurSpace() {
        return this.const_context.getCurSpace();
    }

    public AddrSpace getConstSpace() {
        return this.const_context.getConstSpace();
    }

    public Address getAddr() {
        return this.const_context.getAddr();
    }

    public Address getNaddr() {
        return this.const_context.getNaddr();
    }

    public Address getFlowRefAddr() {
        return this.const_context.getFlowRefAddr();
    }

    public Address getFlowDestAddr() {
        return this.const_context.getFlowDestAddr();
    }

    public int getLength() {
        return this.const_context.getLength();
    }

    public int getInstructionBytes(int byteoff, int numbytes) {
        return this.const_context.getInstructionBytes(byteoff, numbytes, this.point.offset);
    }

    public int getContextBytes(int byteoff, int numbytes) {
        return this.const_context.getContextBytes(byteoff, numbytes);
    }

    public int getInstructionBits(int startbit, int size) {
        return this.const_context.getInstructionBits(startbit, size, this.point.offset);
    }

    public int getContextBits(int startbit, int size) {
        return this.const_context.getContextBits(startbit, size);
    }
}

