/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.opbehavior;

import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.utils.Utils;
import java.math.BigInteger;

public class OpBehaviorIntDiv
extends BinaryOpBehavior {
    public OpBehaviorIntDiv() {
        super(33);
    }

    @Override
    public long evaluateBinary(int sizeout, int sizein, long in1, long in2) {
        if (sizein <= 0 || in2 == 0L) {
            return 0L;
        }
        if (in1 == in2) {
            return 1L;
        }
        if (sizein == 8) {
            long mask = Integer.MIN_VALUE;
            long bit1 = in1 & mask;
            long bit2 = in2 & mask;
            if (bit1 != 0L || bit2 != 0L) {
                BigInteger bigIn2;
                BigInteger bigIn1 = Utils.bytesToBigInteger(Utils.longToBytes(in1, sizein, true), sizein, true, false);
                if (bigIn1.signum() < 0) {
                    bigIn1 = Utils.convertToUnsignedValue(bigIn1, sizein);
                }
                if ((bigIn2 = Utils.bytesToBigInteger(Utils.longToBytes(in2, sizein, true), sizein, true, false)).signum() < 0) {
                    bigIn2 = Utils.convertToUnsignedValue(bigIn2, sizein);
                }
                BigInteger result = bigIn1.divide(bigIn2);
                return result.longValue() & Utils.calc_mask(sizeout);
            }
        }
        return in1 / in2 & Utils.calc_mask(sizeout);
    }

    @Override
    public BigInteger evaluateBinary(int sizeout, int sizein, BigInteger in1, BigInteger in2) {
        if (sizein <= 0 || in2.signum() == 0) {
            return BigInteger.ZERO;
        }
        BigInteger res = in1.divide(in2);
        return res;
    }
}

