/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.expression;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class TokenField
extends PatternValue {
    private boolean bigendian;
    private boolean signbit;
    private int bitstart;
    private int bitend;
    private int bytestart;
    private int byteend;
    private int shift;

    public int hashCode() {
        int result = 0;
        result += this.bitstart;
        result *= 31;
        result += this.bitend;
        result *= 31;
        result += Boolean.hashCode(this.signbit);
        result *= 31;
        return result += Boolean.hashCode(this.bigendian);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TokenField)) {
            return false;
        }
        TokenField that = (TokenField)obj;
        if (this.bitstart != that.bitstart) {
            return false;
        }
        if (this.bitend != that.bitend) {
            return false;
        }
        if (this.signbit != that.signbit) {
            return false;
        }
        return this.bigendian == that.bigendian;
    }

    @Override
    public long minValue() {
        return 0L;
    }

    @Override
    public long maxValue() {
        long res = -1L;
        res <<= this.bitend - this.bitstart;
        return (res <<= 1) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public long getValue(ParserWalker walker) throws MemoryAccessException {
        long res = this.getInstructionBytes(walker);
        res >>= this.shift;
        res = this.signbit ? TokenField.signExtend(res, this.bitend - this.bitstart) : TokenField.zeroExtend(res, this.bitend - this.bitstart);
        return res;
    }

    public int getBitStart() {
        return this.bitstart;
    }

    public int getBitEnd() {
        return this.bitend;
    }

    public int getByteStart() {
        return this.bytestart;
    }

    public int getByteEnd() {
        return this.byteend;
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage lang) {
        XmlElement el = parser.start(new String[]{"tokenfield"});
        this.bigendian = SpecXmlUtils.decodeBoolean((String)el.getAttribute("bigendian"));
        this.signbit = SpecXmlUtils.decodeBoolean((String)el.getAttribute("signbit"));
        this.bitstart = SpecXmlUtils.decodeInt((String)el.getAttribute("bitstart"));
        this.bitend = SpecXmlUtils.decodeInt((String)el.getAttribute("bitend"));
        this.bytestart = SpecXmlUtils.decodeInt((String)el.getAttribute("bytestart"));
        this.byteend = SpecXmlUtils.decodeInt((String)el.getAttribute("byteend"));
        this.shift = SpecXmlUtils.decodeInt((String)el.getAttribute("shift"));
        parser.end(el);
    }

    public boolean hasSignbit() {
        return this.signbit;
    }

    private long getInstructionBytes(ParserWalker walker) throws MemoryAccessException {
        long tmp;
        int size;
        int tmpsize;
        long res = 0L;
        int bs = this.bytestart;
        for (tmpsize = size = this.byteend - this.bytestart + 1; tmpsize >= 4; tmpsize -= 4) {
            tmp = walker.getInstructionBytes(bs, 4);
            res <<= 32;
            res |= tmp & 0xFFFFFFFFL;
            bs += 4;
        }
        if (tmpsize > 0) {
            tmp = walker.getInstructionBytes(bs, tmpsize);
            res <<= 8 * tmpsize;
            res |= tmp & 0xFFFFFFFFL;
        }
        if (!this.bigendian) {
            res = TokenField.byteSwap(res, size);
        }
        return res;
    }

    public static long signExtend(long val, int bit) {
        long mask = 0L;
        mask = (mask ^ 0xFFFFFFFFFFFFFFFFL) << bit;
        val = (val >> bit & 1L) != 0L ? (val |= mask) : (val &= mask ^ 0xFFFFFFFFFFFFFFFFL);
        return val;
    }

    public static long zeroExtend(long val, int bit) {
        long mask = 0L;
        mask = (mask ^ 0xFFFFFFFFFFFFFFFFL) << bit;
        return val &= (mask <<= 1) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long byteSwap(long val, int size) {
        long res = 0L;
        while (size > 0) {
            res <<= 8;
            res |= val & 0xFFL;
            val >>= 8;
            --size;
        }
        return res;
    }

    public boolean isBigEndian() {
        return this.bigendian;
    }

    public int getShift() {
        return this.shift;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[ins(" + this.bitstart + "," + this.bitend + ")");
        if (this.signbit) {
            sb.append(", signed");
        }
        if (this.bigendian) {
            sb.append(", bigendian");
        }
        sb.append(", bytes " + this.bytestart + "-" + this.byteend);
        sb.append(", shift=" + this.shift);
        sb.append("]");
        return sb.toString();
    }
}

