/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.EncodedLiteralInstruction;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction21h
extends Instruction
implements SingleRegisterInstruction,
EncodedLiteralInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private short litB;

    public Instruction21h(Opcode opcode, short regA, short litB) {
        super(opcode);
        if (regA >= 256) {
            throw new RuntimeException("The register number must be less than v256");
        }
        this.regA = (byte)regA;
        this.litB = litB;
    }

    private Instruction21h(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        this.regA = buffer[bufferIndex + 1];
        this.litB = NumberUtils.decodeShort(buffer, bufferIndex + 2);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regA);
        out.writeShort(this.litB);
    }

    @Override
    public Format getFormat() {
        return Format.Format21h;
    }

    @Override
    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    @Override
    public long getLiteral() {
        return this.litB;
    }

    @Override
    public long getDecodedLiteral() {
        if (this.opcode == Opcode.CONST_HIGH16) {
            return this.litB << 16;
        }
        assert (this.opcode == Opcode.CONST_WIDE_HIGH16);
        return (long)this.litB << 48;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction21h(opcode, buffer, bufferIndex);
        }
    }
}

