/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.util.AnimatedIcon;
import docking.widgets.OptionDialog;
import ghidra.util.HelpLocation;
import ghidra.util.Issue;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.IssueListener;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorComponent;
import ghidra.util.timer.GTimer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import resources.ResourceManager;

public class TaskDialog
extends DialogComponentProvider
implements TaskMonitor {
    private static final int SLEEPY_TIME = 10;
    private static final int MAX_DELAY = 200000;
    public static final int DEFAULT_WIDTH = 275;
    private Timer showTimer;
    private TaskMonitorComponent monitorComponent;
    private AtomicInteger taskID = new AtomicInteger();
    private boolean canCancel;
    private Runnable updateMessage;
    private Runnable closeDialog;
    private Runnable enableCancelButton;
    private String newMessage;
    private boolean cancelState = true;
    private Component centerOnComp;
    private Runnable shouldCancelRunnable;
    private boolean done;
    private JPanel mainPanel;

    public TaskDialog(Component centerOnComp, Task task) {
        this(centerOnComp, task.getTaskTitle(), task.isModal(), task.canCancel(), task.hasProgress());
    }

    public TaskDialog(Task task) {
        this(task.getTaskTitle(), task.canCancel(), task.isModal(), task.hasProgress());
    }

    public TaskDialog(String title, boolean canCancel, boolean isModal, boolean hasProgress) {
        this(null, title, isModal, canCancel, true);
    }

    private TaskDialog(Component centerOnComp, String title, boolean isModal, boolean canCancel, boolean hasProgress) {
        super(title, isModal, true, canCancel, true);
        this.centerOnComp = centerOnComp;
        this.setup(canCancel, hasProgress);
    }

    private void setup(boolean canCancel, boolean hasProgress) {
        this.canCancel = canCancel;
        this.setRememberLocation(false);
        this.setRememberSize(false);
        this.setTransient(true);
        this.closeDialog = () -> {
            this.close();
            this.dispose();
        };
        this.updateMessage = () -> {
            this.setStatusText(this.newMessage);
            TaskDialog taskDialog = this;
            synchronized (taskDialog) {
                this.newMessage = null;
            }
        };
        this.enableCancelButton = () -> TaskDialog.super.setCancelEnabled(this.cancelState);
        this.shouldCancelRunnable = () -> {
            int currentTaskID = this.taskID.get();
            boolean doCancel = this.promptToVerifyCancel();
            if (doCancel && currentTaskID == this.taskID.get()) {
                this.cancel();
            }
        };
        this.monitorComponent = new TaskMonitorComponent(false, false);
        this.mainPanel = new JPanel(new BorderLayout());
        this.addWorkPanel(this.mainPanel);
        if (hasProgress) {
            this.installProgressMonitor();
        } else {
            this.installActivityDisplay();
        }
        if (canCancel) {
            this.addCancelButton();
        }
        this.setHelpLocation(new HelpLocation("Tool", "TaskDialog"));
    }

    protected boolean promptToVerifyCancel() {
        boolean userSaysYes = OptionDialog.showYesNoDialog(this.getComponent(), "Cancel?", "Do you really want to cancel \"" + this.getTitle() + "\"?") == 1;
        return userSaysYes;
    }

    private void installProgressMonitor() {
        SystemUtilities.runIfSwingOrPostSwingLater(() -> {
            this.mainPanel.removeAll();
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(20, 10, 5, 10));
            panel.add(this.monitorComponent);
            this.mainPanel.add((Component)panel, "North");
            this.repack();
        });
    }

    private void installActivityDisplay() {
        SystemUtilities.runIfSwingOrPostSwingLater(() -> {
            this.mainPanel.removeAll();
            ArrayList<Icon> iconList = new ArrayList<Icon>();
            iconList.add(ResourceManager.loadImage((String)"images/eatbits1.png"));
            iconList.add(ResourceManager.loadImage((String)"images/eatbits2.png"));
            iconList.add(ResourceManager.loadImage((String)"images/eatbits3.png"));
            iconList.add(ResourceManager.loadImage((String)"images/eatbits4.png"));
            iconList.add(ResourceManager.loadImage((String)"images/eatbits5.png"));
            iconList.add(ResourceManager.loadImage((String)"images/eatbits6.png"));
            iconList.add(ResourceManager.loadImage((String)"images/eatbits7.png"));
            AnimatedIcon icon = new AnimatedIcon(iconList, 200, 0);
            JPanel panel = new JPanel(new BorderLayout());
            panel.setSize(new Dimension(200, 100));
            panel.add(new JLabel(icon));
            this.mainPanel.add((Component)panel, "Center");
            this.repack();
        });
    }

    @Override
    protected void dialogShown() {
        if (this.isCompleted()) {
            this.close();
        }
    }

    @Override
    protected void dialogClosed() {
        this.close();
    }

    public void setShowProgressValue(boolean showProgressValue) {
        this.monitorComponent.setShowProgressValue(showProgressValue);
    }

    public void setProgress(long param) {
        this.monitorComponent.setProgress(param);
    }

    public void initialize(long max) {
        if (this.monitorComponent.isIndeterminate()) {
            return;
        }
        if (!this.monitorComponent.isShowing()) {
            this.installProgressMonitor();
        }
        this.monitorComponent.initialize(max);
    }

    public void setMaximum(long max) {
        this.monitorComponent.setMaximum(max);
    }

    public long getMaximum() {
        return this.monitorComponent.getMaximum();
    }

    public void setIndeterminate(boolean indeterminate) {
        this.monitorComponent.setIndeterminate(indeterminate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancelCallback() {
        TaskDialog taskDialog = this;
        synchronized (taskDialog) {
            if (!this.monitorComponent.isCancelEnabled() || this.monitorComponent.isCancelled()) {
                return;
            }
        }
        SwingUtilities.invokeLater(this.shouldCancelRunnable);
    }

    public synchronized void setMessage(String str) {
        boolean invoke = this.newMessage == null;
        this.newMessage = str;
        if (invoke) {
            SwingUtilities.invokeLater(this.updateMessage);
        }
    }

    @Override
    public void setCancelEnabled(boolean enable) {
        if (this.canCancel) {
            this.monitorComponent.setCancelEnabled(enable);
            SwingUtilities.invokeLater(this.enableCancelButton);
        }
    }

    @Override
    public boolean isCancelEnabled() {
        return this.canCancel && this.cancelState;
    }

    public synchronized void taskProcessed() {
        this.done = true;
        this.monitorComponent.notifyChangeListeners();
        SwingUtilities.invokeLater(this.closeDialog);
    }

    public synchronized void reset() {
        this.done = false;
        this.taskID.incrementAndGet();
    }

    public synchronized boolean isCompleted() {
        return this.done;
    }

    public boolean isCancelled() {
        return this.monitorComponent.isCancelled();
    }

    public void show(int delay) {
        if (this.isModal()) {
            this.doShowModal(delay);
        } else {
            this.doShowNonModal(delay);
        }
    }

    private void doShowModal(int delay) {
        this.giveTheTaskThreadAChanceToComplete(delay);
        if (this.isCompleted()) {
            return;
        }
        this.doShow();
    }

    private void doShowNonModal(int delay) {
        GTimer.scheduleRunnable((long)delay, () -> {
            if (this.isCompleted()) {
                return;
            }
            this.doShow();
        });
    }

    protected void doShow() {
        SystemUtilities.runIfSwingOrPostSwingLater(() -> DockingWindowManager.showDialog(this.centerOnComp, this));
    }

    private void giveTheTaskThreadAChanceToComplete(int delay) {
        delay = Math.min(delay, 200000);
        for (int elapsedTime = 0; !this.isCompleted() && elapsedTime < delay; elapsedTime += 10) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        Runnable disposeTask = () -> {
            if (this.showTimer != null) {
                this.showTimer.stop();
                this.showTimer = null;
            }
        };
        SystemUtilities.runSwingNow((Runnable)disposeTask);
    }

    public synchronized void cancel() {
        if (!this.canCancel || this.monitorComponent.isCancelled()) {
            return;
        }
        this.monitorComponent.cancel();
    }

    public synchronized void clearCanceled() {
        this.monitorComponent.clearCanceled();
    }

    public void checkCanceled() throws CancelledException {
        this.monitorComponent.checkCanceled();
    }

    public void incrementProgress(long incrementAmount) {
        this.monitorComponent.incrementProgress(incrementAmount);
    }

    public long getProgress() {
        return this.monitorComponent.getProgress();
    }

    public void addCancelledListener(CancelledListener listener) {
        this.monitorComponent.addCancelledListener(listener);
    }

    public void removeCancelledListener(CancelledListener listener) {
        this.monitorComponent.removeCancelledListener(listener);
    }

    public void addIssueListener(IssueListener listener) {
        this.monitorComponent.addIssueListener(listener);
    }

    public void removeIssueListener(IssueListener listener) {
        this.monitorComponent.removeIssueListener(listener);
    }

    public void reportIssue(Issue issue) {
        this.monitorComponent.reportIssue(issue);
    }
}

