/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.threaded;

import docking.widgets.EmptyBorderButton;
import docking.widgets.table.GTable;
import docking.widgets.table.threaded.ThreadedTableModel;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import resources.Icons;

public class GThreadedTablePanel<T>
extends JPanel {
    private static final int SHOW_PROGRESS_DEFAULT = 1000;
    private static final int MIN_UPDATE_DELAY = 1000;
    private static final int MAX_UPDATE_DELAY = 300000;
    private static final int MIN_INCREMENTAL_UPDATE_DELAY = 250;
    private static final int MAX_INCREMENTAL_UPDATE_DELAY = 2000;
    private GTable table;
    private ThreadedTableModel<T, ?> threadedModel;
    private ThreadedTableModelListener tableListener;
    private MessagePassingTaskMonitor defaultMonitor;
    private IncrementalLoadingTaskMonitor incrementalMonitor;
    private JPanel pendingPanel;
    private TaskMonitorComponent loadingProgressMonitor;
    private JComponent loadedComponent;
    private EmptyBorderButton refreshButton;
    private Timer showTimer;
    private Runnable showProgressRunnable = () -> this.startShowProgressTimer();
    private Runnable showPendingRunnable = () -> this.doShowPendingPanel();
    private Runnable updateCompleteRunnable = () -> this.doUpdateComplete();
    private final int minUpdateDelay;
    private final int maxUpdateDelay;

    public GThreadedTablePanel(ThreadedTableModel<T, ?> model) {
        this(model, GThreadedTablePanel.getMinDelay(model), GThreadedTablePanel.getMaxDelay(model));
    }

    public GThreadedTablePanel(ThreadedTableModel<T, ?> model, int minUpdateDelay) {
        this(model, minUpdateDelay, GThreadedTablePanel.getMaxDelay(model));
    }

    public GThreadedTablePanel(ThreadedTableModel<T, ?> model, int minUpdateDelay, int maxUpdateDelay) {
        super(new BorderLayout());
        this.threadedModel = model;
        this.minUpdateDelay = minUpdateDelay;
        this.maxUpdateDelay = maxUpdateDelay;
        this.buildPending();
        this.table = this.createTable(model);
        this.initializeModel(model);
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    protected GTable createTable(ThreadedTableModel<T, ?> model) {
        return new GTable(model);
    }

    private void initializeModel(ThreadedTableModel<T, ?> model) {
        this.defaultMonitor = new MessagePassingTaskMonitor();
        this.incrementalMonitor = new IncrementalLoadingTaskMonitor(this.defaultMonitor);
        if (this.threadedModel.isLoadIncrementally()) {
            this.defaultMonitor.setMessageRecipient(this.incrementalMonitor);
            this.loadingProgressMonitor = this.incrementalMonitor;
            model.setIncrementalTaskMonitor(this.incrementalMonitor);
        } else {
            this.loadingProgressMonitor = this.defaultMonitor;
        }
        this.tableListener = new TableListener();
        model.addThreadedTableModelListener(this.tableListener);
        model.setDefaultTaskMonitor(this.defaultMonitor);
        model.setUpdateDelay(this.minUpdateDelay, this.maxUpdateDelay);
        this.threadedModel = model;
    }

    public void setModel(ThreadedTableModel<T, ?> model) {
        this.initializeModel(model);
        this.table.setModel(model);
    }

    public void dispose() {
        this.threadedModel.dispose();
        this.table.dispose();
    }

    public TaskMonitor getTaskMonitor() {
        return this.loadingProgressMonitor;
    }

    public void refresh() {
        this.threadedModel.reload();
    }

    public boolean isBusy() {
        return this.threadedModel.isBusy();
    }

    private void buildPending() {
        JLabel label = new JLabel("Update pending...", 0);
        this.refreshButton = new EmptyBorderButton(Icons.REFRESH_ICON);
        this.refreshButton.addActionListener(e -> this.threadedModel.reload());
        this.refreshButton.setToolTipText("Force Refresh Now");
        this.pendingPanel = new JPanel(new FlowLayout());
        this.pendingPanel.setName("Pending Panel");
        this.pendingPanel.add((Component)label, "Center");
        this.pendingPanel.add((Component)this.refreshButton, "East");
    }

    public GTable getTable() {
        return this.table;
    }

    private void handleUpdatePending() {
        SwingUtilities.invokeLater(this.showPendingRunnable);
    }

    private void handleUpdating() {
        SwingUtilities.invokeLater(this.showProgressRunnable);
    }

    private void handleUpdateComplete() {
        SwingUtilities.invokeLater(this.updateCompleteRunnable);
    }

    private void doUpdateComplete() {
        this.incrementalMonitor.reset();
        if (this.showTimer != null) {
            this.showTimer.stop();
        }
        this.doHideProgressPanel();
    }

    private void startShowProgressTimer() {
        this.showTimer = new Timer(1000, ev -> {
            if (this.isBusy()) {
                this.showTimer = null;
                this.doShowProgressPanel();
            }
        });
        this.showTimer.setInitialDelay(1000);
        this.showTimer.setRepeats(false);
        this.showTimer.start();
    }

    private void doShowProgressPanel() {
        if (this.threadedModel.isLoading()) {
            this.doShowLoadingProgressPanel();
        } else {
            this.doShowNonLoadingProgressPanel();
        }
    }

    private void doShowLoadingProgressPanel() {
        if (this.loadedComponent != null) {
            this.remove(this.loadedComponent);
            this.loadedComponent = null;
        }
        this.loadedComponent = this.loadingProgressMonitor;
        this.add((Component)this.loadedComponent, "South");
        this.loadedComponent.invalidate();
        this.table.invalidate();
        this.validate();
        this.repaint();
    }

    private void doShowNonLoadingProgressPanel() {
        if (this.loadedComponent != null) {
            this.remove(this.loadedComponent);
            this.loadedComponent = null;
        }
        this.loadedComponent = this.defaultMonitor;
        this.add((Component)this.loadedComponent, "South");
        this.loadedComponent.invalidate();
        this.table.invalidate();
        this.validate();
        this.repaint();
    }

    private void doHideProgressPanel() {
        if (this.loadedComponent != null) {
            this.remove(this.loadedComponent);
            this.loadedComponent = null;
        }
        this.table.invalidate();
        this.validate();
        this.repaint();
    }

    private void doShowPendingPanel() {
        if (this.loadedComponent != null) {
            this.remove(this.loadedComponent);
        }
        this.loadedComponent = this.pendingPanel;
        this.refreshButton.clearBorder();
        this.add((Component)this.loadedComponent, "South");
        this.loadedComponent.invalidate();
        this.table.invalidate();
        this.validate();
        this.repaint();
    }

    private static int getMinDelay(ThreadedTableModel<?, ?> model) {
        return model.isLoadIncrementally() ? 250 : 1000;
    }

    private static int getMaxDelay(ThreadedTableModel<?, ?> model) {
        return model.isLoadIncrementally() ? 2000 : 300000;
    }

    private class TableListener
    implements ThreadedTableModelListener {
        private TableListener() {
        }

        @Override
        public void loadPending() {
            GThreadedTablePanel.this.handleUpdatePending();
        }

        @Override
        public void loadingStarted() {
            GThreadedTablePanel.this.handleUpdating();
        }

        @Override
        public void loadingFinished(boolean wasCancelled) {
            GThreadedTablePanel.this.handleUpdateComplete();
        }
    }

    private class IncrementalLoadingTaskMonitor
    extends TaskMonitorComponent {
        private final TaskMonitorComponent defaultMonitorComponent;

        public IncrementalLoadingTaskMonitor(TaskMonitorComponent defaultMonitor) {
            this.defaultMonitorComponent = defaultMonitor;
            this.setName("Incremental Task Monitor Component");
        }

        @Override
        public synchronized void setMessage(String message) {
            super.setMessage("[Loading Incrementally] " + message);
        }

        @Override
        public void cancel() {
            this.defaultMonitorComponent.cancel();
            super.cancel();
        }
    }

    private class MessagePassingTaskMonitor
    extends TaskMonitorComponent {
        private TaskMonitorComponent messageRecepientMonitor;

        public MessagePassingTaskMonitor() {
            this.setName("Basic Task Monitor Component");
        }

        @Override
        public synchronized void setMessage(String message) {
            super.setMessage(message);
            if (this.messageRecepientMonitor != null) {
                this.messageRecepientMonitor.setMessage(message);
            }
        }

        void setMessageRecipient(TaskMonitorComponent monitor) {
            this.messageRecepientMonitor = monitor;
        }
    }
}

