/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.SingleValueColumnConstraint;
import docking.widgets.table.constrainteditor.AbstractColumnConstraintEditor;
import docking.widgets.textfield.IntegerTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.math.BigInteger;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UnsignedLongConstraintEditor
extends AbstractColumnConstraintEditor<BigInteger> {
    public static BigInteger MAX_VALUE = new BigInteger("ffffffffffffffff", 16);
    private IntegerTextField field;
    private JLabel statusLabel;

    public UnsignedLongConstraintEditor(ColumnConstraint<BigInteger> constraint) {
        super(constraint);
    }

    @Override
    protected Component buildInlineEditorComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        this.getConstraint().getConstraintValue();
        this.field = new IntegerTextField(16, 0L);
        this.field.setHexMode();
        this.field.setAllowNegativeValues(false);
        this.field.setMaxValue(new BigInteger("FFFFFFFFFFFFFFFF", 16));
        this.field.addChangeListener(e -> this.valueChanged());
        panel.add((Component)this.field.getComponent(), "Center");
        this.statusLabel = new JLabel();
        panel.add((Component)this.statusLabel, "South");
        this.statusLabel.setForeground(Color.RED);
        this.statusLabel.setHorizontalAlignment(0);
        return panel;
    }

    @Override
    public void reset() {
        BigInteger newValue = BigInteger.ZERO;
        this.setValue(this.getConstraint().copy(newValue));
    }

    @Override
    protected ColumnConstraint<BigInteger> getValueFromComponent() {
        return this.getConstraint().copy(this.field.getValue());
    }

    @Override
    protected void updateEditorComponent() {
        if (this.hasEditorComponents()) {
            BigInteger constraintValue = this.getConstraint().getConstraintValue();
            this.field.setValue(constraintValue);
        }
    }

    @Override
    protected boolean checkEditorValueValidity() {
        return this.field.getValue() != null;
    }

    @Override
    protected void updateInfoMessage(boolean isValid) {
        String status = UnsignedLongConstraintEditor.formatStatus(isValid ? "&nbsp;" : "Please enter a value.", true);
        this.statusLabel.setText(status);
    }

    @Override
    public String getErrorMessage() {
        return "";
    }

    private SingleValueColumnConstraint<BigInteger> getConstraint() {
        return (SingleValueColumnConstraint)this.currentConstraint;
    }
}

