/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.SortedTableModel;
import docking.widgets.table.TableSortState;
import docking.widgets.table.TableSortStateEditor;
import java.awt.Toolkit;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableUtils {
    public static final int MAX_SEARCH_ROWS = 50000;

    public static void columnSelected(JTable table, int columnIndex) {
        SortedTableModel sortedModel = TableUtils.getSortedTableModel(table);
        if (sortedModel == null) {
            return;
        }
        int modelColumnIndex = TableUtils.getColumnModelIndex(table, columnIndex);
        if (modelColumnIndex < 0) {
            return;
        }
        if (!sortedModel.isSortable(modelColumnIndex)) {
            return;
        }
        TableSortState columnSortStates = sortedModel.getTableSortState();
        TableSortStateEditor editor = new TableSortStateEditor(columnSortStates);
        if (editor.isColumnSorted(modelColumnIndex)) {
            editor.flipColumnSortDirection(modelColumnIndex);
        } else {
            editor.clear();
            editor.addSortedColumn(modelColumnIndex);
        }
        sortedModel.setTableSortState(editor.createTableSortState());
        TableUtils.repaintTableHeader(table);
    }

    public static void columnAlternativelySelected(JTable table, int columnIndex) {
        SortedTableModel sortedModel = TableUtils.getSortedTableModel(table);
        if (sortedModel == null) {
            return;
        }
        int modelColumnIndex = TableUtils.getColumnModelIndex(table, columnIndex);
        if (modelColumnIndex < 0) {
            return;
        }
        if (!sortedModel.isSortable(modelColumnIndex)) {
            return;
        }
        TableSortState columnSortStates = sortedModel.getTableSortState();
        TableSortStateEditor editor = new TableSortStateEditor(columnSortStates);
        if (editor.isColumnSorted(modelColumnIndex)) {
            if (editor.getSortedColumnCount() == 1) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            editor.removeSortedColumn(modelColumnIndex);
        } else {
            editor.addSortedColumn(modelColumnIndex);
        }
        sortedModel.setTableSortState(editor.createTableSortState());
        TableUtils.repaintTableHeader(table);
    }

    private static SortedTableModel getSortedTableModel(JTable table) {
        TableModel model = table.getModel();
        if (!(model instanceof SortedTableModel)) {
            return null;
        }
        return (SortedTableModel)model;
    }

    private static int getColumnModelIndex(JTable table, int columnIndex) {
        TableColumnModel columnModel = table.getColumnModel();
        return columnModel.getColumn(columnIndex).getModelIndex();
    }

    private static void repaintTableHeader(JTable table) {
        JTableHeader tableHeader = table.getTableHeader();
        if (tableHeader != null) {
            tableHeader.paintImmediately(tableHeader.getBounds());
        }
    }
}

