/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.SortListener;
import docking.widgets.table.SortedTableModel;
import docking.widgets.table.TableSortState;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

@Deprecated
public class DefaultSortedTableModel
extends AbstractTableModel
implements SortedTableModel,
TableModelListener {
    private WeakSet<SortListener> listeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private TableSortState tableSortState = new TableSortState();
    private int[] indexes;
    private boolean sortEnabled = true;
    private Map<Integer, Comparator<?>> registeredComparatorMap = new HashMap();
    protected TableModel model;

    private TableSortState createSortState(int column, boolean ascending) {
        ColumnSortState sortState = new ColumnSortState(column, ascending ? ColumnSortState.SortDirection.ASCENDING : ColumnSortState.SortDirection.DESCENDING, 1);
        return new TableSortState(sortState);
    }

    public void setSort(int column, boolean ascending) {
        TableSortState sortState = this.createSortState(column, ascending);
        this.setTableSortState(sortState);
    }

    @Override
    public int getPrimarySortColumnIndex() {
        return this.tableSortState.iterator().next().getColumnModelIndex();
    }

    public boolean isAscending() {
        return true;
    }

    @Deprecated
    public DefaultSortedTableModel(TableModel model) {
        if (model == null) {
            throw new NullPointerException("Model cannot be null!");
        }
        if (model instanceof AbstractSortedTableModel) {
            throw new AssertException("You cannot pass an AbstractSortedTableModel to " + this.getClass().getSimpleName() + "--it is already sorted!");
        }
        this.setModel(model);
        this.init();
    }

    private void init() {
        TableSortState defaultSortState;
        this.tableSortState = defaultSortState = this.createSortState(0, true);
    }

    public void setModel(TableModel model) {
        if (model == null) {
            throw new NullPointerException("Model cannot be null!");
        }
        this.model = model;
        model.addTableModelListener(this);
        this.reallocateIndexes();
    }

    public TableModel getModel() {
        return this.model;
    }

    public void enableSorter(boolean enable) {
        this.sortEnabled = enable;
        if (!this.sortEnabled) {
            return;
        }
        this.reallocateIndexes();
        this.sort();
        SystemUtilities.runIfSwingOrPostSwingLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DefaultSortedTableModel.this.notifySorted();
            }
        });
    }

    private void notifySorted() {
        this.fireTableChangedEvent();
        for (SortListener listener : this.listeners) {
            listener.modelSorted(this.tableSortState);
        }
    }

    private void fireTableChangedEvent() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void addSortListener(SortListener l) {
        this.listeners.add((Object)l);
    }

    public void registerComparator(Comparator<?> comparator, int column) {
        this.registeredComparatorMap.put(column, comparator);
    }

    public void deRegisterComparator(int column) {
        this.registeredComparatorMap.remove(column);
    }

    private int compareRowsByColumn(int row1, int row2, int column) {
        TableModel data = this.model;
        Object o1 = data.getValueAt(row1, column);
        Object o2 = data.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        Comparator<?> comparator = this.getComparator(column);
        Object value1 = data.getValueAt(row1, column);
        Object value2 = data.getValueAt(row2, column);
        return comparator.compare(value1, value2);
    }

    private Comparator<?> getComparator(int column) {
        Comparator<?> comparator = this.registeredComparatorMap.get(column);
        if (comparator != null) {
            return comparator;
        }
        return DEFAULT_COMPARATOR;
    }

    private int compare(int row1, int row2) {
        for (ColumnSortState columnSortState : this.tableSortState) {
            int result = this.compareRowsByColumn(row1, row2, columnSortState.getColumnModelIndex());
            if (result == 0) continue;
            return columnSortState.isAscending() ? result : -result;
        }
        return 0;
    }

    private void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        this.indexes = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.indexes[row] = row;
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.sortEnabled) {
            this.reallocateIndexes();
            this.sort();
        }
        this.fireTableChanged(e);
    }

    private void checkModel() {
        if (this.indexes.length == this.model.getRowCount()) {
            return;
        }
        if (!this.sortEnabled) {
            return;
        }
        Msg.error((Object)this, (Object)"Sorter not informed of a change in model.");
    }

    private void sort() {
        this.checkModel();
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    private void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    @Override
    public Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    public int getSortedIndex(int aRow) {
        this.checkModel();
        return this.indexes[aRow];
    }

    @Override
    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    public void sortByColumn(int column) {
        ColumnSortState sortState = new ColumnSortState(column, ColumnSortState.SortDirection.ASCENDING, 1);
        TableSortState newCollection = new TableSortState(sortState);
        this.setTableSortState(newCollection);
    }

    @Override
    public boolean isSortable(int columnIndex) {
        return true;
    }

    public void resort() {
        this.tableChanged(new TableModelEvent(this));
    }

    @Override
    public TableSortState getTableSortState() {
        return this.tableSortState;
    }

    @Override
    public void setTableSortState(TableSortState sortStates) {
        this.tableSortState = sortStates;
        this.resort();
    }

    @Override
    public int getRowCount() {
        return this.indexes.length;
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public String getColumnName(int aColumn) {
        return this.model.getColumnName(aColumn);
    }

    @Override
    public Class<?> getColumnClass(int aColumn) {
        return this.model.getColumnClass(aColumn);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.model.isCellEditable(row, column);
    }
}

