/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.javaclass.format.attributes.InnerClass;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class InnerClassesAttribute
extends AbstractAttributeInfo {
    private short numberOfInnerClasses;
    private InnerClass[] innerClasses;

    public InnerClassesAttribute(BinaryReader reader) throws IOException {
        super(reader);
        this.numberOfInnerClasses = reader.readNextShort();
        this.innerClasses = new InnerClass[this.numberOfInnerClasses];
        for (int i = 0; i < this.numberOfInnerClasses; ++i) {
            this.innerClasses[i] = new InnerClass(reader);
        }
    }

    public short getNumberOfInnerClasses() {
        return this.numberOfInnerClasses;
    }

    public InnerClass[] getInnerClasses() {
        return this.innerClasses;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = this.getBaseStructure("InnerClasses_attribute|" + this.numberOfInnerClasses + "|");
        structure.add(WORD, "number_of_classes", null);
        for (int i = 0; i < this.innerClasses.length; ++i) {
            structure.add(this.innerClasses[i].toDataType(), "inner_class_" + i, null);
        }
        return structure;
    }
}

