/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.javaclass.format.attributes.AnnotationDefaultAttribute;
import ghidra.javaclass.format.attributes.BootstrapMethodsAttribute;
import ghidra.javaclass.format.attributes.CodeAttribute;
import ghidra.javaclass.format.attributes.ConstantValueAttribute;
import ghidra.javaclass.format.attributes.DeprecatedAttribute;
import ghidra.javaclass.format.attributes.EnclosingMethodAttribute;
import ghidra.javaclass.format.attributes.ExceptionsAttribute;
import ghidra.javaclass.format.attributes.InnerClassesAttribute;
import ghidra.javaclass.format.attributes.LineNumberTableAttribute;
import ghidra.javaclass.format.attributes.LocalVariableTableAttribute;
import ghidra.javaclass.format.attributes.LocalVariableTypeTableAttribute;
import ghidra.javaclass.format.attributes.RuntimeInvisibleAnnotationsAttribute;
import ghidra.javaclass.format.attributes.RuntimeParameterAnnotationsAttribute;
import ghidra.javaclass.format.attributes.RuntimeVisibleAnnotationsAttribute;
import ghidra.javaclass.format.attributes.SignatureAttribute;
import ghidra.javaclass.format.attributes.SourceDebugExtensionAttribute;
import ghidra.javaclass.format.attributes.SourceFileAttribute;
import ghidra.javaclass.format.attributes.StackMapTableAttribute;
import ghidra.javaclass.format.attributes.SyntheticAttribute;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.javaclass.format.constantpool.ConstantPoolUtf8Info;
import java.io.IOException;

public class AttributeFactory {
    public static AbstractAttributeInfo get(BinaryReader reader, AbstractConstantPoolInfoJava[] constantPool) throws IOException {
        short attributeNameIndex = reader.readShort(reader.getPointerIndex());
        if (attributeNameIndex < 1 || attributeNameIndex >= constantPool.length) {
            throw new RuntimeException("invalid index");
        }
        if (!(constantPool[attributeNameIndex] instanceof ConstantPoolUtf8Info)) {
            throw new RuntimeException();
        }
        ConstantPoolUtf8Info utf8 = (ConstantPoolUtf8Info)constantPool[attributeNameIndex];
        if (utf8.getString().equals("ConstantValue")) {
            return new ConstantValueAttribute(reader);
        }
        if (utf8.getString().equals("Code")) {
            return new CodeAttribute(reader, constantPool);
        }
        if (utf8.getString().equals("StackMapTable")) {
            return new StackMapTableAttribute(reader);
        }
        if (utf8.getString().equals("Exceptions")) {
            return new ExceptionsAttribute(reader);
        }
        if (utf8.getString().equals("InnerClasses")) {
            return new InnerClassesAttribute(reader);
        }
        if (utf8.getString().equals("EnclosingMethod")) {
            return new EnclosingMethodAttribute(reader);
        }
        if (utf8.getString().equals("Synthetic")) {
            return new SyntheticAttribute(reader);
        }
        if (utf8.getString().equals("Signature")) {
            return new SignatureAttribute(reader);
        }
        if (utf8.getString().equals("SourceFile")) {
            return new SourceFileAttribute(reader);
        }
        if (utf8.getString().equals("SourceDebugExtension")) {
            return new SourceDebugExtensionAttribute(reader);
        }
        if (utf8.getString().equals("LineNumberTable")) {
            return new LineNumberTableAttribute(reader);
        }
        if (utf8.getString().equals("LocalVariableTable")) {
            return new LocalVariableTableAttribute(reader, constantPool);
        }
        if (utf8.getString().equals("LocalVariableTypeTable")) {
            return new LocalVariableTypeTableAttribute(reader);
        }
        if (utf8.getString().equals("Deprecated")) {
            return new DeprecatedAttribute(reader);
        }
        if (utf8.getString().equals("RuntimeVisibleAnnotations")) {
            return new RuntimeVisibleAnnotationsAttribute(reader);
        }
        if (utf8.getString().equals("RuntimeInvisibleAnnotations")) {
            return new RuntimeInvisibleAnnotationsAttribute(reader);
        }
        if (utf8.getString().equals("RuntimeVisibleParameterAnnotations")) {
            return new RuntimeParameterAnnotationsAttribute(reader, true);
        }
        if (utf8.getString().equals("RuntimeInvisibleParameterAnnotations")) {
            return new RuntimeParameterAnnotationsAttribute(reader, false);
        }
        if (utf8.getString().equals("AnnotationDefault")) {
            return new AnnotationDefaultAttribute(reader);
        }
        if (utf8.getString().equals("BootstrapMethods")) {
            return new BootstrapMethodsAttribute(reader);
        }
        throw new RuntimeException("Unknown attribute type: " + utf8.getString());
    }
}

