/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format;

import ghidra.framework.options.Options;
import ghidra.javaclass.format.JavaClassConstants;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.util.Arrays;

public class JavaClassUtil {
    public static final long LOOKUP_ADDRESS = 0xE0000000L;
    public static final long METHOD_INDEX_SIZE = 262144L;

    public static final boolean isClassFile(Program program) {
        Options options = program.getOptions("Program Information");
        String firmwarePath = options.getString("Firmware Path", "");
        if (program.getExecutablePath().toLowerCase().endsWith(".class") || firmwarePath.toLowerCase().endsWith(".class")) {
            byte[] bytes = new byte[4];
            try {
                Address address = program.getAddressFactory().getAddressSpace("constantPool").getMinAddress();
                program.getMemory().getBytes(address, bytes);
            }
            catch (Exception e) {
                Msg.info(JavaClassUtil.class, (Object)e.getLocalizedMessage());
            }
            return Arrays.equals(bytes, JavaClassConstants.MAGIC_BYTES);
        }
        return false;
    }

    public static Address toLookupAddress(Program program, int methodIndex) {
        AddressFactory addressFactory = program.getAddressFactory();
        AddressSpace defaultAddressSpace = addressFactory.getDefaultAddressSpace();
        return defaultAddressSpace.getAddress(0xE0000000L + (long)(methodIndex * 4));
    }
}

