/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format;

public abstract class AccessFlagsJava {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int SUPER = 32;
    public static final int VOLATILE = 64;
    public static final int BRIDGE = 64;
    public static final int TRANSIENT = 128;
    public static final int VARARGS = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;
    public static final int SYNTHETIC = 4096;
    public static final int ANNOTATION = 8192;
    public static final int ENUM = 16384;

    public static String toString(int access, boolean isClass) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((access & 1) == 1) {
            stringBuffer.append("public ");
        }
        if ((access & 2) == 2) {
            stringBuffer.append("private ");
        }
        if ((access & 4) == 4) {
            stringBuffer.append("protected ");
        }
        if ((access & 8) == 8) {
            stringBuffer.append("static ");
        }
        if ((access & 0x10) == 16) {
            stringBuffer.append("final ");
        }
        if (!isClass && (access & 0x20) == 32) {
            stringBuffer.append("synchronized ");
        }
        if ((access & 0x40) == 64) {
            stringBuffer.append("volatile ");
        }
        if ((access & 0x80) == 128) {
            stringBuffer.append("transient ");
        }
        if ((access & 0x100) == 256) {
            stringBuffer.append("native ");
        }
        if ((access & 0x400) == 1024 && (access & 0x200) == 0) {
            stringBuffer.append("abstract ");
        }
        return stringBuffer.toString();
    }

    public static boolean isStatic(int access) {
        return (access & 8) == 8;
    }

    public static final boolean isPublic(int access) {
        return (access & 1) == 1;
    }

    public static final boolean isProtected(int access) {
        return (access & 4) == 4;
    }

    public static final boolean isPackagePrivate(int access) {
        return (access & 7) == 0;
    }

    public static final boolean isPrivate(int access) {
        return (access & 2) == 2;
    }

    public static final boolean isInterface(int access) {
        return (access & 0x200) == 512;
    }
}

