/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.pcodeInject.PcodeTextEmitter;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.Varnode;
import java.io.IOException;

public class SwitchMethods {
    static final String KEY = "key";
    static final String SWITCH_TARGET = "switch_target";

    public static String getPcodeForLookupSwitch(InjectContext injectContext, Program program) throws IOException {
        StringBuilder pCode = new StringBuilder();
        int defaultAddr = (int)((Varnode)injectContext.inputlist.get(0)).getOffset();
        int numPairs = (int)((Varnode)injectContext.inputlist.get(1)).getOffset();
        int padding = (int)((Varnode)injectContext.inputlist.get(2)).getOffset();
        PcodeTextEmitter.emitPopCat1Value(pCode, KEY);
        int target = (int)(injectContext.baseAddr.getOffset() + (long)defaultAddr);
        PcodeTextEmitter.emitAssignConstantToRegister(pCode, SWITCH_TARGET, target);
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), injectContext.baseAddr);
        byte[] bytes = provider.readBytes((long)(1 + padding + 8), (long)(8 * numPairs));
        int length = bytes.length;
        for (int i = 0; i < length; i += 8) {
            int match = bytes[i] << 24 & 0xFF000000 | bytes[i + 1] << 16 & 0xFF0000 | bytes[i + 2] << 8 & 0xFF00 | bytes[i + 3] & 0xFF;
            int offset = bytes[i + 4] << 24 & 0xFF000000 | bytes[i + 5] << 16 & 0xFF0000 | bytes[i + 6] << 8 & 0xFF00 | bytes[i + 7] & 0xFF;
            target = (int)(injectContext.baseAddr.getOffset() + (long)offset);
            pCode.append("if (key != " + match + ") goto <test" + i + ">;\n");
            pCode.append(SWITCH_TARGET);
            pCode.append(" = inst_start + " + offset + ";\n");
            PcodeTextEmitter.emitLabelDefinition(pCode, "test" + i);
        }
        pCode.append("SP=SP;\n");
        provider.close();
        return pCode.toString();
    }
}

