/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.functiontype;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDType;
import mdemangler.datatype.MDDataType;
import mdemangler.datatype.MDDataTypeParser;
import mdemangler.datatype.modifier.MDBasedAttribute;
import mdemangler.datatype.modifier.MDCVMod;
import mdemangler.functiontype.MDArgumentsList;
import mdemangler.functiontype.MDCallingConvention;
import mdemangler.functiontype.MDThrowAttribute;

public class MDFunctionType
extends MDType {
    private MDCallingConvention convention;
    private MDDataType retType;
    private MDArgumentsList argsList;
    private MDCVMod thisPointerCVMod;
    private MDThrowAttribute throwAttribute;
    private boolean hasCVModifier = false;
    private boolean hasReturn = true;
    private boolean hasArgs = true;
    private boolean isTypeCast;
    protected boolean fromModifier = false;
    protected MDBasedAttribute based;

    public void setBased(MDBasedAttribute based) {
        this.based = based;
    }

    public MDFunctionType(MDMang dmang) {
        super(dmang);
    }

    public MDCallingConvention getCallingConvention() {
        return this.convention;
    }

    public MDDataType getReturnType() {
        return this.retType;
    }

    public MDArgumentsList getArgumentsList() {
        return this.argsList;
    }

    public MDCVMod getThisPointerCVMod() {
        return this.thisPointerCVMod;
    }

    public MDThrowAttribute getThrowAttribute() {
        return this.throwAttribute;
    }

    public void setFromModifier() {
        this.fromModifier = true;
    }

    public void setThisPointerCVMod(MDCVMod thisPointerCVMod) {
        this.thisPointerCVMod = thisPointerCVMod;
    }

    public void setHasCVModifier() {
        this.hasCVModifier = true;
    }

    public void clearHasCVModifier() {
        this.hasCVModifier = false;
    }

    public void setNoReturn() {
        this.hasReturn = false;
    }

    public boolean hasArgs() {
        return this.hasArgs;
    }

    public void setNoArgs() {
        this.hasArgs = false;
    }

    public boolean isTypeCast() {
        return this.isTypeCast;
    }

    public void setTypeCast() {
        this.isTypeCast = true;
    }

    @Override
    protected void parseInternal() throws MDException {
        super.parseInternal();
        this.dmang.pushFunctionContext();
        if (this.hasCVModifier) {
            this.thisPointerCVMod = new MDCVMod(this.dmang);
            this.thisPointerCVMod.setThisPointerMod();
            this.thisPointerCVMod.parse();
        }
        this.convention = new MDCallingConvention(this.dmang);
        this.convention.parse();
        if (this.hasReturn) {
            this.retType = MDDataTypeParser.parseDataType(this.dmang, this.isTypeCast);
            this.retType.parse();
        }
        if (this.hasArgs) {
            this.argsList = new MDArgumentsList(this.dmang);
            this.argsList.parse();
            this.throwAttribute = new MDThrowAttribute(this.dmang);
            this.throwAttribute.parse();
        }
        this.dmang.popContext();
    }

    @Override
    public void insert(StringBuilder builder) {
        String ta;
        super.insert(builder);
        if (builder.length() != 0 && builder.charAt(0) != ' ' && builder.charAt(0) != '*' && builder.charAt(0) != '&' && builder.charAt(0) != '(') {
            this.dmang.insertString(builder, " ");
        }
        StringBuilder conventionBuilder = new StringBuilder();
        this.convention.insert(conventionBuilder);
        if (this.based != null) {
            this.based.append(conventionBuilder);
        }
        this.dmang.cleanOutput(conventionBuilder);
        this.dmang.insertString(builder, conventionBuilder.toString());
        if (this.hasReturn && this.isTypeCast) {
            StringBuilder retBuilder = new StringBuilder();
            this.retType.insert(retBuilder);
            this.dmang.appendString(builder, " ");
            this.dmang.appendString(builder, retBuilder.toString());
        }
        if (this.fromModifier) {
            this.dmang.insertString(builder, "(");
            this.dmang.appendString(builder, ")");
        }
        if (this.hasArgs) {
            this.dmang.appendString(builder, "(");
            this.argsList.insert(builder);
            this.dmang.appendString(builder, ")");
        }
        if (this.thisPointerCVMod != null) {
            StringBuilder cvBuilder = new StringBuilder();
            this.thisPointerCVMod.insert(cvBuilder);
            this.dmang.appendString(builder, cvBuilder.toString());
        }
        if (this.hasReturn && !this.isTypeCast) {
            this.retType.insert(builder);
        }
        if (this.throwAttribute != null && (ta = this.throwAttribute.toString()).length() != 0) {
            this.dmang.appendString(builder, " " + ta);
        }
    }
}

