/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.cmd.comments.SetCommentsCmd;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.PseudoInstruction;
import ghidra.app.util.bin.format.pdb.PdbParserNEW;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.WideCharDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

final class PdbUtil {
    PdbUtil() {
    }

    static final Address reladdr(Program program, int relativeOffset) {
        return PdbUtil.reladdr(program, (long)relativeOffset & 0xFFFFFFFFL);
    }

    static final Address reladdr(Program program, long relativeOffset) {
        return program.getImageBase().add(relativeOffset);
    }

    static final void appendComment(Program program, Address address, String text, int commentType) {
        String comment = program.getListing().getComment(commentType, address);
        if (comment != null) {
            if (comment.contains((CharSequence)text)) {
                return;
            }
            text = comment + "\n" + (String)text;
        }
        SetCommentsCmd.createComment((Program)program, (Address)address, (String)text, (int)commentType);
    }

    static final boolean isFunction(Program program, String symbol, Address addr, int length) {
        int atpos = symbol.lastIndexOf(64);
        if (atpos > 0) {
            String s = symbol.substring(atpos + 1);
            try {
                Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
            PseudoDisassembler dis = new PseudoDisassembler(program);
            Address tmp = addr;
            while (tmp.subtract(addr) < (long)length) {
                try {
                    PseudoInstruction instr = dis.disassemble(tmp);
                    tmp = tmp.add((long)instr.getLength());
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    static final void ensureSize(int expectedLength, Composite composite, MessageLog log) {
        int actualLength = composite.getLength();
        if (actualLength < expectedLength) {
            composite.setInternallyAligned(false);
            if (composite instanceof Structure) {
                Structure struct;
                struct.growStructure(expectedLength - actualLength + ((struct = (Structure)composite).isNotYetDefined() ? 1 : 0));
            } else {
                ArrayDataType datatype = new ArrayDataType(DataType.DEFAULT, expectedLength, DataType.DEFAULT.getLength());
                composite.add((DataType)datatype);
            }
        } else if (actualLength > expectedLength) {
            log.appendMsg("Warning: Composite data type generated from PDB has size mismatch. " + composite.getName() + ": expected 0x" + Integer.toHexString(expectedLength) + ", but was 0x" + Integer.toHexString(actualLength));
        }
    }

    static final void clearComponents(Composite composite) {
        if (composite instanceof Structure) {
            ((Structure)composite).deleteAll();
        } else {
            while (composite.getNumComponents() > 0) {
                composite.delete(0);
            }
        }
    }

    static final String getPass(int pass) {
        if (pass > 20) {
            pass %= 10;
        }
        switch (pass) {
            case 1: {
                return pass + "st pass";
            }
            case 2: {
                return pass + "nd pass";
            }
            case 3: {
                return pass + "rd pass";
            }
        }
        return pass + "th pass";
    }

    static final void createMandatoryDataTypes(PdbParserNEW parser, TaskMonitor monitor) {
        DataTypeManager dtm = parser.getProgramDataTypeManager();
        parser.addDataType((DataType)new TypedefDataType("wchar", (DataType)WideCharDataType.dataType));
        parser.addDataType((DataType)new TypedefDataType("__int8", AbstractIntegerDataType.getSignedDataType((int)1, (DataTypeManager)dtm)));
        parser.addDataType((DataType)new TypedefDataType("__uint8", AbstractIntegerDataType.getUnsignedDataType((int)1, (DataTypeManager)dtm)));
        parser.addDataType((DataType)new TypedefDataType("__int16", AbstractIntegerDataType.getSignedDataType((int)2, (DataTypeManager)dtm)));
        parser.addDataType((DataType)new TypedefDataType("__uint16", AbstractIntegerDataType.getUnsignedDataType((int)2, (DataTypeManager)dtm)));
        parser.addDataType((DataType)new TypedefDataType("__int32", AbstractIntegerDataType.getSignedDataType((int)4, (DataTypeManager)dtm)));
        parser.addDataType((DataType)new TypedefDataType("__uint32", AbstractIntegerDataType.getUnsignedDataType((int)2, (DataTypeManager)dtm)));
        parser.addDataType((DataType)new TypedefDataType("__int64", AbstractIntegerDataType.getSignedDataType((int)8, (DataTypeManager)dtm)));
        parser.addDataType((DataType)new TypedefDataType("__uint64", AbstractIntegerDataType.getUnsignedDataType((int)8, (DataTypeManager)dtm)));
    }
}

