/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pdb.PdbInfoIface;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class PdbInfo
implements PdbInfoIface {
    public static final int MAGIC = 1312960816;
    private byte[] magic;
    private int offset;
    private int sig;
    private int age;
    private String pdbName;

    public static boolean isMatch(BinaryReader reader, int ptr) throws IOException {
        int value = reader.readByte((long)ptr) << 24 | reader.readByte((long)(ptr + 1)) << 16 | reader.readByte((long)(ptr + 2)) << 8 | reader.readByte((long)(ptr + 3));
        return 1312960816 == value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdbInfo(BinaryReader reader, int ptr) throws IOException {
        long origIndex = reader.getPointerIndex();
        reader.setPointerIndex(ptr);
        try {
            this.magic = reader.readNextByteArray(4);
            this.offset = reader.readNextInt();
            this.sig = reader.readNextInt();
            this.age = reader.readNextInt();
            this.pdbName = reader.readNextAsciiString();
        }
        finally {
            reader.setPointerIndex(origIndex);
        }
    }

    public byte[] getMagic() {
        return this.magic;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSig() {
        return this.sig;
    }

    public int getAge() {
        return this.age;
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("PdbInfo", 0);
        struct.add((DataType)new StringDataType(), this.magic.length, "signature", null);
        struct.add((DataType)new DWordDataType(), "offset", null);
        struct.add((DataType)new DWordDataType(), "sig", null);
        struct.add((DataType)new DWordDataType(), "age", null);
        struct.add((DataType)new StringDataType(), this.pdbName.length(), "pdbname", null);
        struct.setCategoryPath(new CategoryPath("/PDB"));
        return struct;
    }
}

