/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.IntListIndexer;
import java.io.Serializable;

public class IntIntIndexedList
implements Serializable {
    private static final short DEFAULT_CAPACITY = 16;
    private int[] values;
    private IntListIndexer indexer;
    private int capacity;

    public IntIntIndexedList(int numLists) {
        this.indexer = new IntListIndexer(numLists, 16);
        this.capacity = this.indexer.getCapacity();
        this.values = new int[this.capacity];
    }

    public void add(int listID, int value) {
        int index = this.indexer.add(listID);
        if (index >= this.capacity) {
            this.grow(this.indexer.getCapacity());
        }
        this.values[index] = value;
    }

    public void append(int listID, int value) {
        int index = this.indexer.append(listID);
        if (index >= this.capacity) {
            this.grow(this.indexer.getCapacity());
        }
        this.values[index] = value;
    }

    public boolean remove(int listID, int value) {
        int index = this.findIndex(listID, value);
        if (index < 0) {
            return false;
        }
        this.indexer.remove(listID, index);
        return true;
    }

    public void removeAll(int listID) {
        this.indexer.removeAll(listID);
    }

    public boolean contains(int listID, int value) {
        int index = this.findIndex(listID, value);
        return index != -1;
    }

    public int getCount(int listID) {
        return this.indexer.getListSize(listID);
    }

    public int[] get(int listID) {
        int count = this.indexer.getListSize(listID);
        int[] lvalues = new int[count];
        int p = this.indexer.first(listID);
        for (int i = 0; i < count; ++i) {
            lvalues[i] = this.values[p];
            p = this.indexer.next(p);
        }
        return lvalues;
    }

    public int getNumLists() {
        return this.indexer.getNumLists();
    }

    public void growNumLists(int numLists) {
        this.indexer.growNumLists(numLists);
    }

    public void clear() {
        this.indexer.clear();
    }

    private void grow(int newCapacity) {
        this.capacity = newCapacity;
        int[] tempValues = new int[newCapacity];
        System.arraycopy(this.values, 0, tempValues, 0, this.values.length);
        this.values = tempValues;
    }

    private int findIndex(int listID, int value) {
        int p = this.indexer.first(listID);
        while (p != -1) {
            if (this.values[p] == value) {
                return p;
            }
            p = this.indexer.next(p);
        }
        return -1;
    }
}

