/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.bean;

import generic.util.WindowUtilities;
import ghidra.util.Msg;
import ghidra.util.bean.GGlassPanePainter;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class GGlassPane
extends JComponent {
    private static final Cursor BUSY_CURSOR = Cursor.getPredefinedCursor(3);
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    private static WeakSet<GGlassPane> systemGlassPanes = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private MouseListener blockingMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            Toolkit.getDefaultToolkit().beep();
        }
    };
    private List<GGlassPanePainter> painters = new ArrayList<GGlassPanePainter>();
    private Cursor nonBusyCursor = DEFAULT_CURSOR;
    private boolean isBusy;

    public GGlassPane() {
        systemGlassPanes.add(this);
    }

    public void addPainter(GGlassPanePainter painter) {
        this.painters.add(painter);
        this.repaint();
    }

    public void removePainter(GGlassPanePainter painter) {
        this.painters.remove(painter);
        this.repaint();
    }

    public void setBusy(boolean isBusy) {
        this.isBusy = isBusy;
        this.showBusyCursor(isBusy);
        this.removeMouseListener(this.blockingMouseListener);
        if (isBusy) {
            this.addMouseListener(this.blockingMouseListener);
        }
        this.paintImmediately(this.getBounds());
    }

    public static void setAllGlassPanesBusy(boolean isBusy) {
        for (GGlassPane glassPane : systemGlassPanes) {
            glassPane.setBusy(isBusy);
        }
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public void showBusyCursor(boolean showBusyCursor) {
        Cursor currentCursor = this.getCursor();
        if (showBusyCursor) {
            if (currentCursor.equals(BUSY_CURSOR)) {
                return;
            }
            this.nonBusyCursor = currentCursor;
            this.setCursor(BUSY_CURSOR);
        } else {
            if (!currentCursor.equals(BUSY_CURSOR)) {
                return;
            }
            this.setCursor(this.nonBusyCursor);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        for (GGlassPanePainter painter : this.painters) {
            painter.paint(this, g);
        }
    }

    @Override
    public boolean contains(int x, int y) {
        Cursor currentCursor = this.getCursor();
        return currentCursor.equals(BUSY_CURSOR);
    }

    public static GGlassPane getGlassPane(Component component) {
        Window window = WindowUtilities.windowForComponent(component);
        if (window instanceof JFrame) {
            JFrame frame = (JFrame)window;
            Component glass = frame.getGlassPane();
            if (!(glass instanceof GGlassPane)) {
                Msg.error(GGlassPane.class, (Object)("GGlassPane not installed on window: " + window), (Throwable)new AssertException());
                return null;
            }
            return (GGlassPane)glass;
        }
        if (window instanceof JDialog) {
            JDialog frame = (JDialog)window;
            Component glass = frame.getGlassPane();
            if (!(glass instanceof GGlassPane)) {
                Msg.error(GGlassPane.class, (Object)("GGlassPane not installed on window: " + window), (Throwable)new AssertException());
                return null;
            }
            return (GGlassPane)glass;
        }
        return null;
    }
}

