/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.CustomOptionsEditor;
import ghidra.framework.options.ErrorPropertyEditor;
import ghidra.framework.options.Options;
import ghidra.framework.options.PropertyBoolean;
import ghidra.framework.options.PropertySelector;
import ghidra.framework.options.PropertyText;
import ghidra.util.SystemUtilities;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.HashSet;
import java.util.Set;

public class EditorState
implements PropertyChangeListener {
    private Object originalValue;
    private Object currentValue;
    private PropertyEditor editor;
    private Set<PropertyChangeListener> listeners = new HashSet<PropertyChangeListener>();
    private Options options;
    private String name;

    public EditorState(Options options, String name) {
        this.options = options;
        this.name = name;
        this.originalValue = this.currentValue = options.getObject(name, null);
        this.editor = options.getPropertyEditor(name);
        this.editor.setValue(this.currentValue);
        this.editor.removePropertyChangeListener(this);
        this.editor.addPropertyChangeListener(this);
    }

    void addListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EditorState other = (EditorState)obj;
        if (!this.options.equals(other.options)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.editor == other.editor;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.currentValue = this.editor.getValue();
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(evt);
        }
    }

    public boolean isValueChanged() {
        return !SystemUtilities.isEqual((Object)this.currentValue, (Object)this.originalValue);
    }

    public void applyValue() {
        if (SystemUtilities.isEqual((Object)this.currentValue, (Object)this.originalValue)) {
            return;
        }
        boolean success = false;
        try {
            Object newValue;
            this.options.putObject(this.name, this.currentValue);
            this.originalValue = newValue = this.options.getObject(this.name, null);
            this.currentValue = newValue;
            success = true;
        }
        finally {
            if (!success) {
                this.editor.setValue(this.originalValue);
                this.currentValue = this.originalValue;
            }
        }
    }

    public boolean supportsCustomOptionsEditor() {
        return this.editor instanceof CustomOptionsEditor;
    }

    public Component getEditorComponent() {
        if (this.editor.supportsCustomEditor()) {
            return this.editor.getCustomEditor();
        }
        if (this.editor.getValue() instanceof Boolean) {
            return new PropertyBoolean(this.editor);
        }
        if (this.editor.getTags() != null) {
            return new PropertySelector(this.editor);
        }
        if (this.editor.getAsText() != null) {
            return new PropertyText(this.editor);
        }
        Class<?> clazz = this.editor.getClass();
        String clazzName = clazz.getSimpleName();
        if (clazzName.startsWith("String")) {
            return new PropertyText(this.editor);
        }
        this.editor.removePropertyChangeListener(this);
        this.editor = new ErrorPropertyEditor("Ghidra does not know how to use PropertyEditor: " + this.editor.getClass().getName(), null);
        return this.editor.getCustomEditor();
    }

    public String getTitle() {
        return this.name;
    }

    public String getDescription() {
        return this.options.getDescription(this.name);
    }
}

