/*
 * Decompiled with CFR 0.152.
 */
package generic.continues;

import generic.continues.ContinuesInterceptor;
import generic.continues.ExceptionHandler;
import generic.continues.GenericFactory;
import java.lang.reflect.Constructor;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;

public class ContinuesFactory
implements GenericFactory {
    private static final String CONTINUES_INTERCEPTOR_DISABLED_PROPERTY = "ContinuesInterceptor.disabled";
    private static final boolean disabled = System.getProperty("ContinuesInterceptor.disabled") != null;
    private ExceptionHandler exceptionHandler;

    public ContinuesFactory(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("exceptionHandler == null not allowed");
        }
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public Object create(Class<?> type, Object ... args) {
        try {
            Object thing;
            if (disabled) {
                Constructor<?> c = type.getConstructor(new Class[0]);
                thing = c.newInstance(args);
            } else {
                ContinuesInterceptor interceptor = new ContinuesInterceptor(this.exceptionHandler);
                Enhancer e = new Enhancer();
                e.setSuperclass(type);
                e.setCallback((Callback)interceptor);
                thing = e.create();
            }
            return thing;
        }
        catch (Throwable e) {
            try {
                this.exceptionHandler.handle(e);
            }
            catch (Throwable t) {
                e = t;
            }
            throw new RuntimeException(e);
        }
    }
}

