/*
 * Decompiled with CFR 0.152.
 */
package generic.concurrent;

import generic.concurrent.ConcurrentQ;
import generic.concurrent.QResult;
import ghidra.util.Issue;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.IssueListener;
import ghidra.util.task.TaskMonitor;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

class FutureTaskMonitor<I, R>
extends FutureTask<R>
implements TaskMonitor {
    private final ConcurrentQ<I, R> queue;
    private final I item;
    private final long id;
    private volatile long currentProgress;
    private volatile long maxProgress;
    private volatile CancelledListener cancelledListener;

    FutureTaskMonitor(ConcurrentQ<I, R> queue, Callable<R> callable, I item, long id) {
        super(callable);
        this.queue = queue;
        this.id = id;
        this.item = item;
    }

    I getItem() {
        return this.item;
    }

    long getID() {
        return this.id;
    }

    @Override
    public void run() {
        super.run();
        QResult result = new QResult(this.item, this);
        this.queue.itemProcessed(this, result);
    }

    public void setMaximum(long max) {
        this.maxProgress = max;
        this.queue.maxProgressChanged(this.id, this.item, max);
    }

    public void incrementProgress(long incrementAmount) {
        this.currentProgress += incrementAmount;
        this.queue.progressChanged(this.id, this.item, this.currentProgress);
    }

    public void setProgress(long value) {
        this.currentProgress = value;
        this.queue.progressChanged(this.id, this.item, this.currentProgress);
    }

    public void checkCanceled() throws CancelledException {
        if (this.isCancelled()) {
            throw new CancelledException();
        }
    }

    public void setMessage(String message) {
        this.queue.progressMessageChanged(this.id, this.item, message);
    }

    public void initialize(long max) {
        this.currentProgress = 0L;
        this.maxProgress = max;
        this.queue.maxProgressChanged(this.id, this.item, max);
        this.queue.progressChanged(this.id, this.item, this.currentProgress);
    }

    public long getMaximum() {
        return this.maxProgress;
    }

    public void setShowProgressValue(boolean showProgressValue) {
    }

    public void setIndeterminate(boolean indeterminate) {
        this.queue.progressModeChanged(this.id, this.item, indeterminate);
    }

    public long getProgress() {
        return this.currentProgress;
    }

    public void reportIssue(Issue issue) {
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = super.cancel(mayInterruptIfRunning);
        CancelledListener listener = this.cancelledListener;
        if (listener != null) {
            listener.cancelled();
        }
        return result;
    }

    public void cancel() {
        this.cancel(true);
    }

    public void setCancelEnabled(boolean enable) {
        throw new UnsupportedOperationException();
    }

    public boolean isCancelEnabled() {
        return true;
    }

    public void clearCanceled() {
        throw new UnsupportedOperationException();
    }

    public synchronized void addCancelledListener(CancelledListener listener) {
        this.cancelledListener = this.cancelledListener == null ? listener : new ChainedCancelledListener(this.cancelledListener, listener);
    }

    public synchronized void removeCancelledListener(CancelledListener listener) {
        if (this.cancelledListener == listener) {
            this.cancelledListener = null;
        } else if (this.cancelledListener instanceof ChainedCancelledListener) {
            this.cancelledListener = ((ChainedCancelledListener)this.cancelledListener).removeListener(listener);
        }
    }

    public void addIssueListener(IssueListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeIssueListener(IssueListener listener) {
        throw new UnsupportedOperationException();
    }

    private static class ChainedCancelledListener
    implements CancelledListener {
        private volatile CancelledListener listener1;
        private volatile CancelledListener listener2;

        public ChainedCancelledListener(CancelledListener listener1, CancelledListener listener2) {
            this.listener1 = listener1;
            this.listener2 = listener2;
        }

        public CancelledListener removeListener(CancelledListener listener) {
            if (this.listener1 == listener) {
                return this.listener2;
            }
            if (this.listener2 == listener) {
                return this.listener1;
            }
            if (this.listener1 instanceof ChainedCancelledListener) {
                this.listener1 = ((ChainedCancelledListener)this.listener1).removeListener(listener);
            }
            if (this.listener2 instanceof ChainedCancelledListener) {
                this.listener2 = ((ChainedCancelledListener)this.listener2).removeListener(listener);
            }
            return this;
        }

        public void cancelled() {
            this.listener1.cancelled();
            this.listener2.cancelled();
        }
    }
}

