/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.tool;

import ghidra.framework.ToolUtils;
import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.model.DefaultToolChangeListener;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Tool;
import ghidra.framework.model.ToolAssociationInfo;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolChestChangeListener;
import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.project.tool.GhidraToolTemplate;
import ghidra.framework.project.tool.ToolManagerImpl;
import ghidra.framework.project.tool.WorkspaceImpl;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.xml.GenericXMLOutputter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Document;

class ToolServicesImpl
implements ToolServices {
    private static String TOOL_ASSOCIATION_PREFERENCE = "ToolAssociation";
    private static String SEPARATOR = ":";
    private ToolChest toolChest;
    private ToolManagerImpl toolManager;
    private List<DefaultToolChangeListener> listeners = new ArrayList<DefaultToolChangeListener>();
    private ToolChestChangeListener toolChestChangeListener;
    private Set<ContentHandler> contentHandlers;

    ToolServicesImpl(ToolChest toolChest, ToolManagerImpl toolManager) {
        this.toolChest = toolChest;
        this.toolManager = toolManager;
    }

    void dispose() {
        this.toolChest.removeToolChestChangeListener(this.toolChestChangeListener);
    }

    @Override
    public void closeTool(Tool tool) {
        this.toolManager.closeTool(tool);
    }

    @Override
    public void exportTool(File location, Tool tool) throws FileNotFoundException, IOException {
        String filename = location.getName();
        if (filename.endsWith(".tool")) {
            filename = filename.substring(0, filename.length() - 5);
        }
        FileOutputStream f = new FileOutputStream(location.getParent() + File.separator + filename + ".tool");
        BufferedOutputStream bf = new BufferedOutputStream(f);
        ToolTemplate template = tool.getToolTemplate(false);
        Document doc = new Document(template.saveToXml());
        GenericXMLOutputter xmlout = new GenericXMLOutputter();
        try {
            xmlout.output(doc, (OutputStream)bf);
        }
        catch (IOException ioe) {
            Msg.error((Object)this, (Object)"Unexpected exception exporting tool", (Throwable)ioe);
        }
        f.close();
    }

    @Override
    public void saveTool(Tool tool) {
        boolean toolChanged = tool.hasConfigChanged();
        ToolTemplate template = tool.saveToolToToolTemplate();
        this.toolManager.toolSaved(tool, toolChanged);
        this.toolChest.replaceToolTemplate(template);
        this.toolManager.setWorkspaceChanged((WorkspaceImpl)this.toolManager.getActiveWorkspace());
    }

    @Override
    public ToolChest getToolChest() {
        return this.toolChest;
    }

    @Override
    public void displaySimilarTool(Tool tool, DomainFile domainFile, PluginEvent event) {
        Tool[] similarTools = this.getSameNamedRunningTools(tool);
        Tool matchingTool = this.findToolUsingFile(similarTools, domainFile);
        if (matchingTool != null) {
            matchingTool.toFront();
        } else {
            Workspace workspace = this.toolManager.getActiveWorkspace();
            matchingTool = workspace.runTool(tool.getToolTemplate(true));
            matchingTool.setVisible(true);
            matchingTool.acceptDomainFiles(new DomainFile[]{domainFile});
        }
        matchingTool.firePluginEvent(event);
    }

    @Override
    public Tool launchDefaultTool(DomainFile domainFile) {
        ToolTemplate template = this.getDefaultToolTemplate(domainFile);
        if (template != null) {
            Workspace workspace = this.toolManager.getActiveWorkspace();
            Tool tool = workspace.runTool(template);
            tool.setVisible(true);
            if (domainFile != null) {
                tool.acceptDomainFiles(new DomainFile[]{domainFile});
            }
            return tool;
        }
        return null;
    }

    @Override
    public Tool launchTool(String toolName, DomainFile domainFile) {
        GhidraToolTemplate template = this.findToolChestToolTemplate(toolName);
        if (template != null) {
            Workspace workspace = this.toolManager.getActiveWorkspace();
            Tool tool = workspace.runTool(template);
            tool.setVisible(true);
            if (domainFile != null) {
                tool.acceptDomainFiles(new DomainFile[]{domainFile});
            }
            return tool;
        }
        return null;
    }

    @Override
    public void setContentTypeToolAssociations(Set<ToolAssociationInfo> infos) {
        for (ToolAssociationInfo info : infos) {
            ContentHandler handler = info.getContentHandler();
            String contentType = handler.getContentType();
            String preferenceKey = this.getToolAssociationPreferenceKey(contentType);
            if (!info.isDefault()) {
                ToolTemplate template = info.getCurrentTemplate();
                String toolName = template.getName();
                Preferences.setProperty((String)preferenceKey, (String)toolName);
            } else {
                Preferences.setProperty((String)preferenceKey, null);
            }
            this.ensureToolIsInToolChest(info.getCurrentTemplate());
        }
        Preferences.store();
    }

    private void ensureToolIsInToolChest(ToolTemplate template) {
        if (template == null) {
            return;
        }
        ToolTemplate existingTemplate = this.toolChest.getToolTemplate(template.getName());
        if (existingTemplate != null) {
            return;
        }
        this.toolChest.addToolTemplate(template);
    }

    @Override
    public Set<ToolAssociationInfo> getContentTypeToolAssociations() {
        HashSet<ToolAssociationInfo> set = new HashSet<ToolAssociationInfo>();
        Set<ContentHandler> handlers = this.getContentHandlers();
        for (ContentHandler contentHandler : handlers) {
            set.add(this.createToolAssociationInfo(contentHandler));
        }
        return set;
    }

    private ToolAssociationInfo createToolAssociationInfo(ContentHandler contentHandler) {
        String contentType = contentHandler.getContentType();
        String defaultToolName = contentHandler.getDefaultToolName();
        String userPreferredToolName = Preferences.getProperty((String)this.getToolAssociationPreferenceKey(contentType), null, (boolean)true);
        if (userPreferredToolName != null) {
            GhidraToolTemplate userDefinedTemplate = this.findToolChestToolTemplate(userPreferredToolName);
            return new ToolAssociationInfo(contentHandler, userPreferredToolName, userDefinedTemplate, this.findDefaultToolTemplate(defaultToolName));
        }
        GhidraToolTemplate defaultToolChestTemplate = this.findToolChestToolTemplate(defaultToolName);
        return new ToolAssociationInfo(contentHandler, defaultToolName, defaultToolChestTemplate, this.findDefaultToolTemplate(defaultToolName));
    }

    @Override
    public ToolTemplate getDefaultToolTemplate(DomainFile domainFile) {
        String contentType = domainFile.getContentType();
        String toolName = Preferences.getProperty((String)this.getToolAssociationPreferenceKey(contentType), null, (boolean)true);
        if (toolName == null) {
            toolName = this.getDefaultToolAssociation(contentType);
        }
        return this.findToolChestToolTemplate(toolName);
    }

    @Override
    public Set<ToolTemplate> getCompatibleTools(Class<? extends DomainObject> domainClass) {
        ToolTemplate[] toolTemplates;
        HashMap<String, ToolTemplate> nameToTemplateMap = new HashMap<String, ToolTemplate>();
        for (ToolTemplate toolTemplate : toolTemplates = this.toolChest.getToolTemplates()) {
            Class<?>[] types;
            for (Class<? extends DomainObject> clazz : types = toolTemplate.getSupportedDataTypes()) {
                if (!clazz.isAssignableFrom(domainClass)) continue;
                nameToTemplateMap.put(toolTemplate.getName(), toolTemplate);
            }
        }
        Set<ContentHandler> compatibleHandlers = this.getCompatibleContentHandlers(domainClass);
        for (ContentHandler handler : compatibleHandlers) {
            String defaultToolName = handler.getDefaultToolName();
            if (nameToTemplateMap.get(defaultToolName) != null) continue;
            GhidraToolTemplate toolChestTemplate = this.findToolChestToolTemplate(defaultToolName);
            if (toolChestTemplate != null) {
                nameToTemplateMap.put(toolChestTemplate.getName(), toolChestTemplate);
                continue;
            }
            GhidraToolTemplate defaultToolTemplate = this.findDefaultToolTemplate(defaultToolName);
            if (defaultToolTemplate == null) continue;
            nameToTemplateMap.put(defaultToolTemplate.getName(), defaultToolTemplate);
        }
        Set<ToolTemplate> defaultTools = ToolUtils.getAllApplicationTools();
        for (ToolTemplate toolTemplate : defaultTools) {
            Class<?>[] types;
            String toolName = toolTemplate.getName();
            if (nameToTemplateMap.get(toolName) != null) continue;
            for (Class<? extends DomainObject> clazz : types = toolTemplate.getSupportedDataTypes()) {
                if (!clazz.isAssignableFrom(domainClass)) continue;
                nameToTemplateMap.put(toolName, toolTemplate);
            }
        }
        return new HashSet<ToolTemplate>(nameToTemplateMap.values());
    }

    private Set<ContentHandler> getCompatibleContentHandlers(Class<? extends DomainObject> domainClass) {
        HashSet<ContentHandler> set = new HashSet<ContentHandler>();
        Set<ContentHandler> handlers = this.getContentHandlers();
        for (ContentHandler contentHandler : handlers) {
            Class<? extends DomainObject> handlerDomainClass = contentHandler.getDomainObjectClass();
            if (handlerDomainClass != domainClass) continue;
            set.add(contentHandler);
        }
        return set;
    }

    private String getToolAssociationPreferenceKey(String contentType) {
        return TOOL_ASSOCIATION_PREFERENCE + SEPARATOR + contentType;
    }

    private String getDefaultToolAssociation(String contentType) {
        Set<ContentHandler> handlers = this.getContentHandlers();
        for (ContentHandler contentHandler : handlers) {
            String type = contentHandler.getContentType();
            if (!type.equals(contentType)) continue;
            return contentHandler.getDefaultToolName();
        }
        return null;
    }

    private Set<ContentHandler> getContentHandlers() {
        if (this.contentHandlers != null) {
            return this.contentHandlers;
        }
        this.contentHandlers = new HashSet<ContentHandler>();
        Set instances = ClassSearcher.getInstances(ContentHandler.class);
        for (ContentHandler contentHandler : instances) {
            String contentType = contentHandler.getContentType();
            if (contentType == null) {
                Msg.error(DomainObjectAdapter.class, (Object)("ContentHandler " + contentHandler.getClass().getName() + " does not specify a content type"));
                continue;
            }
            String toolName = contentHandler.getDefaultToolName();
            if (toolName == null) {
                Msg.error(DomainObjectAdapter.class, (Object)("ContentHandler " + contentHandler.getClass().getName() + " does not specify a default tool"));
                continue;
            }
            this.contentHandlers.add(contentHandler);
        }
        return this.contentHandlers;
    }

    @Override
    public void addDefaultToolChangeListener(DefaultToolChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDefaultToolChangeListener(DefaultToolChangeListener listener) {
        this.listeners.remove(listener);
    }

    private GhidraToolTemplate findToolChestToolTemplate(String toolName) {
        if (toolName != null) {
            return (GhidraToolTemplate)this.toolChest.getToolTemplate(toolName);
        }
        return null;
    }

    private GhidraToolTemplate findDefaultToolTemplate(String defaultToolName) {
        if (defaultToolName == null) {
            return null;
        }
        Set<ToolTemplate> defaultTools = ToolUtils.getAllApplicationTools();
        for (ToolTemplate toolTemplate : defaultTools) {
            if (!defaultToolName.equals(toolTemplate.getName())) continue;
            return (GhidraToolTemplate)toolTemplate;
        }
        return null;
    }

    private Tool[] getSameNamedRunningTools(Tool tool) {
        String toolName = tool.getToolName();
        Tool[] tools = this.toolManager.getRunningTools();
        ArrayList<Tool> toolList = new ArrayList<Tool>(tools.length);
        for (Tool element : tools) {
            if (!toolName.equals(element.getToolName())) continue;
            toolList.add(element);
        }
        return toolList.toArray(new Tool[toolList.size()]);
    }

    @Override
    public Tool[] getRunningTools() {
        return this.toolManager.getRunningTools();
    }

    private Tool findToolUsingFile(Tool[] tools, DomainFile domainFile) {
        Tool matchingTool = null;
        block0: for (int toolNum = 0; toolNum < tools.length && matchingTool == null; ++toolNum) {
            DomainFile[] df;
            PluginTool pTool = (PluginTool)tools[toolNum];
            for (DomainFile element : df = pTool.getDomainFiles()) {
                if (!domainFile.equals(element)) continue;
                matchingTool = tools[toolNum];
                continue block0;
            }
        }
        return matchingTool;
    }

    @Override
    public boolean canAutoSave(Tool tool) {
        return this.toolManager.canAutoSave(tool);
    }
}

