/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.mgr;

import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.exception.AssertException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;

public class ProjectActionManager
implements PropertyChangeListener {
    private DockingWindowManager winMgr;
    private Map<String, List<DockingActionIf>> actionMap;
    private Options keyBindingOptions;
    private PluginTool tool;

    public ProjectActionManager(PluginTool tool, DockingWindowManager winMgr) {
        this.tool = tool;
        this.winMgr = winMgr;
        this.actionMap = new HashMap<String, List<DockingActionIf>>();
        this.keyBindingOptions = tool.getOptions("Key Bindings");
    }

    public void dispose() {
        this.actionMap.clear();
    }

    private void addActionToMap(DockingActionIf action) {
        String name = action.getFullName();
        List<DockingActionIf> actionList = this.actionMap.get(name);
        if (actionList == null) {
            ArrayList<DockingActionIf> newList = new ArrayList<DockingActionIf>();
            newList.add(action);
            this.actionMap.put(name, newList);
        } else {
            actionList.add(action);
        }
    }

    private void removeActionFromMap(DockingActionIf action) {
        String name = action.getFullName();
        List<DockingActionIf> actionList = this.actionMap.get(name);
        if (actionList == null) {
            return;
        }
        if (actionList.remove(action) && actionList.isEmpty()) {
            this.actionMap.remove(name);
        }
    }

    public synchronized void addToolAction(DockingActionIf action) {
        action.addPropertyChangeListener((PropertyChangeListener)this);
        this.addActionToMap(action);
        if (action.isKeyBindingManaged()) {
            KeyStroke ks = action.getKeyBinding();
            this.keyBindingOptions.registerOption(action.getFullName(), OptionType.KEYSTROKE_TYPE, (Object)ks, null, null);
            KeyStroke newKs = this.keyBindingOptions.getKeyStroke(action.getFullName(), ks);
            if (ks != newKs) {
                action.setUnvalidatedKeyBindingData(new KeyBindingData(newKs));
            }
        }
        this.winMgr.addToolAction(action);
    }

    public synchronized void removeToolAction(DockingActionIf action) {
        action.removePropertyChangeListener((PropertyChangeListener)this);
        this.removeActionFromMap(action);
        this.winMgr.removeToolAction(action);
    }

    public synchronized void removeToolActions(String owner) {
        List<DockingActionIf> actions = this.getActions(owner);
        for (DockingActionIf action : actions) {
            this.removeToolAction(action);
        }
    }

    public synchronized void addLocalAction(ComponentProvider provider, DockingActionIf action) {
        this.checkForAlreadyAddedAction(provider, action);
        action.addPropertyChangeListener((PropertyChangeListener)this);
        this.addActionToMap(action);
        if (action.isKeyBindingManaged()) {
            KeyStroke ks = action.getKeyBinding();
            this.keyBindingOptions.registerOption(action.getFullName(), OptionType.KEYSTROKE_TYPE, (Object)ks, null, null);
            KeyStroke newKs = this.keyBindingOptions.getKeyStroke(action.getFullName(), ks);
            if (ks != newKs) {
                action.setUnvalidatedKeyBindingData(new KeyBindingData(newKs));
            }
        }
        this.winMgr.addLocalAction(provider, action);
    }

    private void checkForAlreadyAddedAction(ComponentProvider provider, DockingActionIf action) {
        String name = action.getFullName();
        List<DockingActionIf> actionList = this.actionMap.get(name);
        if (actionList == null) {
            return;
        }
        if (actionList.contains(action)) {
            throw new AssertException("Cannot add the same action more than once. Provider " + provider.getName() + " - action: " + name);
        }
    }

    public synchronized void removeProviderAction(ComponentProvider provider, DockingActionIf action) {
        action.removePropertyChangeListener((PropertyChangeListener)this);
        this.removeActionFromMap(action);
        this.winMgr.removeProviderAction(provider, action);
    }

    public List<DockingActionIf> getDockingActionsByFullActionName(String fullActionName) {
        List<DockingActionIf> list = this.actionMap.get(fullActionName);
        if (list == null) {
            return new ArrayList<DockingActionIf>();
        }
        return new ArrayList<DockingActionIf>(list);
    }

    private List<DockingActionIf> getUniqueActionList(String owner) {
        ArrayList<DockingActionIf> matchingActionList = new ArrayList<DockingActionIf>();
        for (List<DockingActionIf> actionList : this.actionMap.values()) {
            DockingActionIf action = actionList.get(0);
            if (owner != null && !action.getOwner().equals(owner)) continue;
            matchingActionList.add(action);
        }
        return matchingActionList;
    }

    public synchronized List<DockingActionIf> getActions(String owner) {
        List<DockingActionIf> list = this.getUniqueActionList(owner);
        return list;
    }

    public List<DockingActionIf> getAllActions() {
        return this.getUniqueActionList(null);
    }

    public synchronized void restoreKeyBindings() {
        this.keyBindingOptions = this.tool.getOptions("Key Bindings");
        List<DockingActionIf> actions = this.getAllActions();
        for (DockingActionIf action : actions) {
            KeyStroke newKs;
            KeyStroke ks;
            if (!action.isKeyBindingManaged() || (ks = action.getKeyBinding()) == (newKs = this.keyBindingOptions.getKeyStroke(action.getFullName(), ks))) continue;
            action.setUnvalidatedKeyBindingData(new KeyBindingData(newKs));
        }
    }

    public void removeComponent(ComponentProvider provider) {
        Iterator iterator = this.winMgr.getComponentActions(provider);
        while (iterator.hasNext()) {
            DockingActionIf action = (DockingActionIf)iterator.next();
            String name = action.getFullName();
            List<DockingActionIf> actionList = this.actionMap.get(name);
            if (actionList == null || !actionList.remove(action) || !actionList.isEmpty()) continue;
            this.actionMap.remove(name);
        }
        this.winMgr.removeComponent(provider);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("KeyBindings")) {
            DockingAction action = (DockingAction)evt.getSource();
            if (!action.isKeyBindingManaged()) {
                this.tool.setConfigChanged(true);
                return;
            }
            KeyBindingData keyBindingData = (KeyBindingData)evt.getNewValue();
            KeyStroke newKeyStroke = keyBindingData.getKeyBinding();
            ToolOptions opt = this.tool.getOptions("Key Bindings");
            KeyStroke optKeyStroke = opt.getKeyStroke(action.getFullName(), null);
            if (newKeyStroke == null) {
                opt.removeOption(action.getFullName());
            } else if (!newKeyStroke.equals(optKeyStroke)) {
                opt.setKeyStroke(action.getFullName(), newKeyStroke);
                this.tool.setConfigChanged(true);
            }
        }
    }
}

