/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import docking.AbstractDockingTool;
import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockWinListener;
import docking.DockingContextListener;
import docking.DockingTool;
import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.EditListener;
import docking.ErrLogDialog;
import docking.ErrorReporter;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.actions.DockingToolActionManager;
import docking.framework.AboutDialog;
import docking.framework.ApplicationInformationDisplayFactory;
import docking.framework.SplashScreen;
import docking.help.Help;
import docking.help.HelpService;
import docking.widgets.OptionDialog;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.UserAgreementDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.Tool;
import ghidra.framework.model.ToolListener;
import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginManager;
import ghidra.framework.plugintool.PluginToolMacAboutHandler;
import ghidra.framework.plugintool.PluginToolMacQuitHandler;
import ghidra.framework.plugintool.PopupListener;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.dialog.ExtensionTableProvider;
import ghidra.framework.plugintool.dialog.ManagePluginsDialog;
import ghidra.framework.plugintool.mgr.DialogManager;
import ghidra.framework.plugintool.mgr.EventManager;
import ghidra.framework.plugintool.mgr.OptionsManager;
import ghidra.framework.plugintool.mgr.ServiceManager;
import ghidra.framework.plugintool.mgr.ToolTaskManager;
import ghidra.framework.plugintool.util.OptionsService;
import ghidra.framework.plugintool.util.PluginClassManager;
import ghidra.framework.plugintool.util.PluginEventListener;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.framework.plugintool.util.ServiceListener;
import ghidra.framework.plugintool.util.TransientToolState;
import ghidra.framework.plugintool.util.UndoRedoToolState;
import ghidra.framework.project.ProjectDataService;
import ghidra.framework.project.tool.ToolIconURL;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jdom.Content;
import org.jdom.Element;

public abstract class PluginTool
extends AbstractDockingTool
implements Tool,
DockWinListener,
ServiceProvider {
    private static final String DOCKING_WINDOWS_ON_TOP = "Docking Windows On Top";
    private static final String SAVE_DIALOG_TITLE = "Save Tool - Possible Conflict";
    private ProjectManager projectManager;
    private Project project;
    private String instanceName = "";
    protected String toolName;
    private String fullName;
    private String subTitle;
    private ServiceManager serviceMgr;
    private ToolTaskManager taskMgr;
    private OptionsManager optionsMgr;
    private PluginManager pluginMgr;
    private EventManager eventMgr;
    private DialogManager dialogMgr;
    private PropertyChangeSupport propertyChangeMgr;
    private WeakSet<PopupListener> popupListeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private OptionsChangeListener optionsListener = new ToolOptionsListener();
    protected ManagePluginsDialog manageDialog;
    protected ExtensionTableProvider extensionTableProvider;
    protected ToolIconURL iconURL = new ToolIconURL("view_detailed.png");
    private DockingAction exportToolAction;
    private ToolServices toolServices;
    private boolean isConfigurable = true;
    protected boolean isDisposed = false;

    public PluginTool(Project project, ToolTemplate template) {
        this(project, project.getProjectManager(), project.getToolServices(), template.getName(), true, true, false);
        this.setIconURL(template.getIconURL());
        boolean hasErrors = this.restoreFromXml(template.getToolElement());
        if (!hasErrors) {
            this.configChangedFlag = false;
        }
        this.optionsMgr.validateOptions();
    }

    public PluginTool(Project project, String name, boolean isDockable, boolean hasStatus, boolean isModal) {
        this(project, project.getProjectManager(), project.getToolServices(), name, isDockable, hasStatus, isModal);
    }

    public PluginTool(Project project, ProjectManager projectManager, ToolServices toolServices, String name, boolean isDockable, boolean hasStatus, boolean isModal) {
        this.project = project;
        this.projectManager = projectManager;
        this.toolServices = toolServices;
        this.propertyChangeMgr = new PropertyChangeSupport(this);
        this.winMgr = this.createDockingWindowManager(isDockable, hasStatus, isModal);
        this.taskMgr = new ToolTaskManager(this);
        this.optionsMgr = new OptionsManager(this);
        this.setToolOptionsHelpLocation();
        this.winMgr.addStatusItem(this.taskMgr.getMonitorComponent(), false, true);
        this.winMgr.removeStatusItem(this.taskMgr.getMonitorComponent());
        this.eventMgr = new EventManager(this);
        this.serviceMgr = new ServiceManager();
        this.installServices();
        this.actionMgr = new DockingToolActionManager((DockingTool)this, this.winMgr);
        this.pluginMgr = new PluginManager(this, this.serviceMgr);
        this.dialogMgr = new DialogManager(this);
        this.initActions();
        this.initOptions();
        this.setToolName(name);
        PluginToolMacQuitHandler.install(this);
        PluginToolMacAboutHandler.install(this.winMgr);
        this.installHomeButton();
    }

    public abstract PluginClassManager getPluginClassManager();

    protected DockingWindowManager createDockingWindowManager(boolean isDockable, boolean hasStatus, boolean isModal) {
        List windowIcons = ApplicationInformationDisplayFactory.getWindowIcons();
        DockingWindowManager newManager = new DockingWindowManager("EMPTY", windowIcons, (DockWinListener)this, isModal, isDockable, hasStatus, null);
        return newManager;
    }

    protected void installHomeButton() {
        ImageIcon homeIcon = ApplicationInformationDisplayFactory.getHomeIcon();
        if (homeIcon == null) {
            Msg.debug((Object)this, (Object)"If you would like a button to show the Front End, then set the home icon");
            return;
        }
        Runnable callback = ApplicationInformationDisplayFactory.getHomeCallback();
        this.winMgr.setHomeButton((Icon)homeIcon, callback);
    }

    protected void initActions() {
    }

    public DockingWindowManager getWindowManager() {
        return this.winMgr;
    }

    private void setDefaultOptionValues() {
        ToolOptions toolOptions = this.optionsMgr.getOptions("Tool");
        boolean windowsOnTop = toolOptions.getBoolean(DOCKING_WINDOWS_ON_TOP, false);
        this.winMgr.setWindowsOnTop(windowsOnTop);
    }

    private void initOptions() {
        ToolOptions toolOptions = this.optionsMgr.getOptions("Tool");
        toolOptions.registerOption(DOCKING_WINDOWS_ON_TOP, (Object)false, null, "Determines whether a docked window will always be shown on top of its parent window.");
        this.setDefaultOptionValues();
        toolOptions.addOptionsChangeListener(this.optionsListener);
        this.serviceMgr.addService(OptionsService.class, this.optionsMgr);
    }

    protected void optionsChanged(Options options, String name, Object oldValue, Object newValue) {
        if (name.equals(DOCKING_WINDOWS_ON_TOP)) {
            this.winMgr.setWindowsOnTop(((Boolean)newValue).booleanValue());
        }
    }

    public void setWindowsOnTop(boolean b) {
        this.winMgr.setWindowsOnTop(b);
    }

    public boolean isWindowsOnTop() {
        return this.winMgr.isWindowsOnTop();
    }

    public void addPopupListener(PopupListener listener) {
        this.popupListeners.add((Object)listener);
    }

    public ManagePluginsDialog getManagePluginsDialog() {
        return this.manageDialog;
    }

    public void showConfig(boolean addSaveActions, boolean isNewTool) {
        if (this.manageDialog != null) {
            this.manageDialog.close();
        }
        this.manageDialog = new ManagePluginsDialog(this, addSaveActions, isNewTool);
        this.showDialog(this.manageDialog);
    }

    public void showExtensions() {
        if (this.extensionTableProvider != null) {
            this.extensionTableProvider.close();
        }
        this.extensionTableProvider = new ExtensionTableProvider(this);
        this.showDialog(this.extensionTableProvider);
    }

    public void removePopupListener(PopupListener listener) {
        this.popupListeners.remove((Object)listener);
    }

    public void addAction(DockingActionIf action) {
        this.actionMgr.addToolAction(action);
    }

    public void addLocalAction(ComponentProvider provider, DockingActionIf action) {
        this.actionMgr.addLocalAction(provider, action);
    }

    public void removeAction(DockingActionIf action) {
        this.actionMgr.removeToolAction(action);
    }

    public void addComponentProvider(ComponentProvider provider, boolean show) {
        Runnable r = () -> this.winMgr.addComponent(provider, show);
        SystemUtilities.runSwingNow((Runnable)r);
    }

    public void showComponentHeader(ComponentProvider provider, boolean b) {
        this.winMgr.showComponentHeader(provider, b);
    }

    public boolean isActive(ComponentProvider provider) {
        return this.winMgr.isActiveProvider(provider);
    }

    public void showComponentProvider(ComponentProvider provider, boolean visibleState) {
        Runnable r = () -> this.winMgr.showComponent(provider, visibleState);
        SystemUtilities.runSwingNow((Runnable)r);
    }

    public void toFront(ComponentProvider provider) {
        Runnable r = () -> this.winMgr.toFront(provider);
        SystemUtilities.runSwingNow((Runnable)r);
    }

    public void removeComponentProvider(ComponentProvider provider) {
        Runnable r = () -> this.actionMgr.removeComponent(provider);
        SystemUtilities.runSwingNow((Runnable)r);
    }

    public void updateTitle(ComponentProvider provider) {
        this.winMgr.updateTitle(provider);
    }

    public boolean isVisible(ComponentProvider provider) {
        return this.winMgr.isVisible(provider);
    }

    public boolean isVisible() {
        return this.winMgr.isVisible();
    }

    public void setVisible(boolean visibility) {
        this.winMgr.setVisible(visibility);
    }

    public void toFront() {
        JFrame frame = this.winMgr.getRootFrame();
        if (frame.getExtendedState() == 1) {
            frame.setExtendedState(0);
        }
        frame.toFront();
    }

    public JFrame getToolFrame() {
        return this.winMgr.getRootFrame();
    }

    private void installServices() {
        this.serviceMgr.addService(ProjectDataService.class, () -> this.project.getProjectData());
    }

    public boolean isService(Class<?> serviceInterface) {
        return this.serviceMgr.isService(serviceInterface);
    }

    public <T> T getService(Class<T> c) {
        return this.serviceMgr.getService(c);
    }

    public <T> T[] getServices(Class<T> c) {
        return this.serviceMgr.getServices(c);
    }

    <T> void addService(Class<T> interfaceClass, T service) {
        this.serviceMgr.addService(interfaceClass, service);
    }

    void removeService(Class<?> interfaceClass, Object service) {
        this.serviceMgr.removeService(interfaceClass, service);
    }

    public void addServiceListener(ServiceListener listener) {
        this.serviceMgr.addServiceListener(listener);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.serviceMgr.removeServiceListener(listener);
    }

    public void setStatusInfo(String text, boolean beep) {
        this.winMgr.setStatusText(text);
        if (beep) {
            Toolkit tk = this.getToolFrame().getToolkit();
            tk.beep();
        }
    }

    public void setStatusInfo(String text) {
        this.winMgr.setStatusText(text);
    }

    public void clearStatusInfo() {
        this.winMgr.setStatusText("");
    }

    public void setDefaultComponent(ComponentProvider provider) {
        this.winMgr.setDefaultComponent(provider);
    }

    @Override
    public ToolTemplate getToolTemplate(boolean includeConfigState) {
        throw new UnsupportedOperationException("You cannot create templates for generic tools: " + this.getClass().getName());
    }

    @Override
    public ToolTemplate saveToolToToolTemplate() {
        this.setConfigChanged(false);
        this.optionsMgr.removeUnusedOptions();
        return this.getToolTemplate(true);
    }

    @Override
    public Element saveWindowingDataToXml() {
        throw new UnsupportedOperationException("You cannot persist generic tools: " + this.getClass().getName());
    }

    @Override
    public void restoreWindowingDataFromXml(Element windowData) {
        throw new UnsupportedOperationException("You cannot persist generic tools: " + this.getClass().getName());
    }

    @Override
    public boolean acceptDomainFiles(DomainFile[] data) {
        return this.pluginMgr.acceptData(data);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeMgr.addPropertyChangeListener(l);
    }

    @Override
    public void addToolListener(ToolListener listener) {
        this.eventMgr.addToolListener(listener);
    }

    public boolean hasToolListeners() {
        return this.eventMgr.hasToolListeners();
    }

    @Override
    public void exit() {
        this.dispose();
    }

    protected void dispose() {
        this.isDisposed = true;
        this.pluginMgr.close();
        if (this.project != null && this.project.getToolManager() != null) {
            this.project.getToolManager().disconnectTool(this);
        }
        if (this.manageDialog != null) {
            this.manageDialog.close();
        }
        this.winMgr.setVisible(false);
        this.eventMgr.clearLastEvents();
        this.pluginMgr.dispose();
        this.actionMgr.dispose();
        if (this.project != null) {
            this.project.releaseFiles(this);
        }
        this.optionsMgr.dispose();
        this.disposeManagers();
        this.winMgr.dispose();
    }

    private void disposeManagers() {
        this.taskMgr.dispose();
    }

    @Override
    public void firePluginEvent(PluginEvent event) {
        this.eventMgr.fireEvent(event);
    }

    @Override
    public String[] getConsumedToolEventNames() {
        return this.eventMgr.getEventsConsumed();
    }

    @Override
    public DomainFile[] getDomainFiles() {
        return this.pluginMgr.getData();
    }

    public ImageIcon getIcon() {
        return this.iconURL.getIcon();
    }

    @Override
    public ToolIconURL getIconURL() {
        return this.iconURL;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    public String getName() {
        return this.fullName;
    }

    @Override
    public Class<?>[] getSupportedDataTypes() {
        return this.pluginMgr.getSupportedDataTypes();
    }

    @Override
    public String[] getToolEventNames() {
        return this.eventMgr.getEventsProduced();
    }

    @Override
    public String getToolName() {
        return this.toolName;
    }

    @Override
    public void putInstanceName(String newInstanceName) {
        this.instanceName = newInstanceName;
        this.fullName = this.instanceName.length() == 0 ? this.toolName : this.toolName + "(" + this.instanceName + ")";
        this.updateTitle();
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeMgr.removePropertyChangeListener(l);
    }

    @Override
    public void removeToolListener(ToolListener listener) {
        this.eventMgr.removeToolListener(listener);
    }

    @Override
    public void restoreDataStateFromXml(Element root) {
        this.pluginMgr.restoreDataStateFromXml(root);
        this.setConfigChanged(false);
    }

    @Override
    public Element saveDataStateToXml(boolean savingProject) {
        return this.pluginMgr.saveDataStateToXml(savingProject);
    }

    protected boolean restoreFromXml(Element root) {
        this.toolName = root.getAttributeValue("TOOL_NAME");
        this.instanceName = root.getAttributeValue("INSTANCE_NAME");
        this.fullName = this.instanceName.length() == 0 ? this.toolName : this.toolName + "(" + this.instanceName + ")";
        SplashScreen.updateSplashScreenStatus((String)("Loading " + this.fullName + " ..."));
        this.restoreOptionsFromXml(root);
        this.setDefaultOptionValues();
        boolean hasErrors = false;
        try {
            this.pluginMgr.restorePluginsFromXml(root);
        }
        catch (PluginException e) {
            hasErrors = true;
            Msg.showError((Object)this, (Component)this.getToolFrame(), (String)"Error Restoring Plugins", (Object)e.getMessage());
        }
        this.winMgr.restoreFromXML(root);
        this.winMgr.setToolName(this.fullName);
        return hasErrors;
    }

    @Override
    public Element saveToXml(boolean includeConfigState) {
        Element root = new Element("TOOL");
        root.setAttribute("TOOL_NAME", this.toolName);
        root.setAttribute("INSTANCE_NAME", this.instanceName);
        root.addContent((Content)this.optionsMgr.getConfigState());
        this.pluginMgr.saveToXml(root, includeConfigState);
        this.winMgr.saveToXML(root);
        return root;
    }

    public void setConfigChanged(boolean changed) {
        super.setConfigChanged(changed);
        if (this.manageDialog != null) {
            this.manageDialog.stateChanged();
        }
    }

    @Override
    public void setIconURL(ToolIconURL newIconURL) {
        if (newIconURL == null) {
            throw new NullPointerException("iconURL cannot be null.");
        }
        this.setConfigChanged(true);
        if (newIconURL.equals(this.iconURL)) {
            return;
        }
        ImageIcon oldValue = this.iconURL.getSmallIcon();
        this.iconURL = newIconURL;
        ImageIcon newValue = this.iconURL.getSmallIcon();
        this.propertyChangeMgr.firePropertyChange("Icon", oldValue, newValue);
        this.winMgr.setIcon(newValue);
    }

    @Override
    public void setToolName(String name) {
        String oldName = this.toolName;
        this.toolName = name;
        this.fullName = this.instanceName.length() == 0 ? this.toolName : this.toolName + "(" + this.instanceName + ")";
        this.winMgr.setToolName(this.fullName);
        this.propertyChangeMgr.firePropertyChange("ToolName", oldName, this.toolName);
    }

    @Override
    public void processToolEvent(PluginEvent toolEvent) {
        this.eventMgr.processToolEvent(toolEvent);
    }

    public boolean execute(Command command, DomainObject obj) {
        return this.taskMgr.execute(command, obj);
    }

    public boolean isExecutingCommand() {
        return this.taskMgr.isBusy();
    }

    public boolean threadIsBackgroundTaskThread() {
        ThreadGroup group;
        ThreadGroup taskGroup = this.taskMgr.getTaskThreadGroup();
        for (group = Thread.currentThread().getThreadGroup(); group != null && group != taskGroup; group = group.getParent()) {
        }
        return group == taskGroup;
    }

    public void executeBackgroundCommand(BackgroundCommand cmd, UndoableDomainObject obj) {
        this.taskMgr.executeCommand(cmd, obj);
    }

    public void terminateBackgroundCommands(boolean wait) {
        this.taskMgr.stop(wait);
    }

    public void scheduleFollowOnCommand(BackgroundCommand cmd, UndoableDomainObject obj) {
        this.taskMgr.scheduleFollowOnCommand(cmd, obj);
    }

    public ToolOptions getOptions(String categoryName) {
        return this.optionsMgr.getOptions(categoryName);
    }

    public void registerOptionsNameChange(String oldName, String newName) {
        this.optionsMgr.registerOptionNameChanged(oldName, newName);
    }

    public boolean hasOptions(String category) {
        return this.optionsMgr.hasOptions(category);
    }

    OptionsManager getOptionsManager() {
        return this.optionsMgr;
    }

    public ToolOptions[] getOptions() {
        return this.optionsMgr.getOptions();
    }

    public void execute(Task task, int delay) {
        new TaskLauncher(task, (Component)this.getToolFrame(), delay);
    }

    public void execute(Task task) {
        new TaskLauncher(task, (Component)this.winMgr.getActiveWindow());
    }

    public Project getProject() {
        return this.project;
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    public ToolServices getToolServices() {
        return this.toolServices;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
        this.updateTitle();
    }

    public void addPlugin(String className) throws PluginException {
        this.checkedRunSwingNow(() -> this.addPlugins(new String[]{className}), PluginException.class);
    }

    public void addPlugins(String[] classNames) throws PluginException {
        try {
            this.pluginMgr.addPlugins(classNames);
        }
        finally {
            this.setConfigChanged(true);
        }
    }

    public void addPlugin(Plugin p) throws PluginException {
        this.pluginMgr.addPlugin(p);
        this.setConfigChanged(true);
    }

    public boolean hasUnsavedData() {
        return this.pluginMgr.hasUnsavedData();
    }

    public void removePlugins(Plugin[] plugins) {
        SystemUtilities.runSwingNow(() -> {
            try {
                this.pluginMgr.removePlugins(plugins);
            }
            finally {
                this.setConfigChanged(true);
            }
        });
    }

    public List<Plugin> getManagedPlugins() {
        return this.pluginMgr.getPlugins();
    }

    public void saveTool() {
        this.toolServices.saveTool(this);
    }

    public boolean saveToolAs() {
        return this.dialogMgr.saveToolAs();
    }

    public void addStatusComponent(JComponent c, boolean addBorder, boolean rightSide) {
        this.winMgr.addStatusItem(c, addBorder, rightSide);
    }

    public void removeStatusComponent(JComponent c) {
        this.winMgr.removeStatusItem(c);
    }

    public List<DockingActionIf> getDockingActionsByFullActionName(String fullActionName) {
        HashSet set = new HashSet();
        set.addAll(this.actionMgr.getDockingActionsByFullActionName(fullActionName));
        set.addAll(this.winMgr.getActions(fullActionName));
        return new ArrayList<DockingActionIf>(set);
    }

    public List<DockingActionIf> getDockingActionsByOwnerName(String owner) {
        List actions = this.actionMgr.getActions(owner);
        return actions;
    }

    public List<DockingActionIf> getAllActions() {
        return this.actionMgr.getAllActions();
    }

    public void removeLocalAction(ComponentProvider provider, DockingActionIf action) {
        this.actionMgr.removeProviderAction(provider, action);
    }

    protected void addExitAction() {
        DockingAction exitAction = new DockingAction("Exit Ghidra", "Tool"){

            public void actionPerformed(ActionContext context) {
                AppInfo.exitGhidra();
            }
        };
        exitAction.setHelpLocation(new HelpLocation("FrontEndPlugin", exitAction.getName()));
        exitAction.setMenuBarData(new MenuData(new String[]{"&File", "E&xit Ghidra"}, null, "Window_Z"));
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() != OperatingSystem.MAC_OS_X) {
            exitAction.setKeyBindingData(new KeyBindingData(81, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        }
        exitAction.setEnabled(true);
        this.addAction((DockingActionIf)exitAction);
    }

    protected void addOptionsAction() {
        DockingAction optionsAction = new DockingAction("Edit Options", "Tool"){

            public void actionPerformed(ActionContext context) {
                PluginTool.this.optionsMgr.editOptions();
            }

            public boolean shouldAddToWindow(boolean isMainWindow, Set<Class<?>> contextTypes) {
                return isMainWindow || !contextTypes.isEmpty();
            }
        };
        optionsAction.setHelpLocation(new HelpLocation("FrontEndPlugin", "Tool Options"));
        MenuData menuData = new MenuData(new String[]{"&Edit", "&Tool Options..."}, null, "AOptions");
        menuData.setMenuSubGroup("AOptions");
        optionsAction.setMenuBarData(menuData);
        optionsAction.setEnabled(true);
        this.addAction((DockingActionIf)optionsAction);
    }

    protected void addSaveToolAction() {
        DockingAction saveAction = new DockingAction("Save Tool", "Tool"){

            public void actionPerformed(ActionContext context) {
                PluginTool.this.saveTool();
            }
        };
        MenuData menuData = new MenuData(new String[]{"&File", "Save Tool"}, null, "Tool");
        menuData.setMenuSubGroup("1Tool");
        saveAction.setMenuBarData(menuData);
        saveAction.setEnabled(true);
        saveAction.setHelpLocation(new HelpLocation("Tool", "Save Tool"));
        DockingAction saveAsAction = new DockingAction("Save Tool As", "Tool"){

            public void actionPerformed(ActionContext context) {
                PluginTool.this.saveToolAs();
            }
        };
        menuData = new MenuData(new String[]{"&File", "Save Tool As..."}, null, "Tool");
        menuData.setMenuSubGroup("2Tool");
        saveAsAction.setMenuBarData(menuData);
        saveAsAction.setEnabled(true);
        saveAsAction.setHelpLocation(new HelpLocation("Tool", "Tool_Changes"));
        this.addAction((DockingActionIf)saveAction);
        this.addAction((DockingActionIf)saveAsAction);
    }

    protected void addExportToolAction() {
        this.exportToolAction = new DockingAction("Export Tool", "Tool"){

            public void actionPerformed(ActionContext context) {
                PluginTool.this.dialogMgr.exportTool();
            }
        };
        MenuData menuData = new MenuData(new String[]{"&File", "Export Tool..."}, null, "Tool");
        menuData.setMenuSubGroup("3Tool");
        this.exportToolAction.setMenuBarData(menuData);
        this.exportToolAction.setEnabled(true);
        this.exportToolAction.setHelpLocation(new HelpLocation("Tool", "Export Tool"));
        this.addAction((DockingActionIf)this.exportToolAction);
    }

    protected void addHelpActions() {
        DockingAction action = new DockingAction("About Ghidra", "Tool"){

            public void actionPerformed(ActionContext context) {
                DockingWindowManager.showDialog((DialogComponentProvider)new AboutDialog());
            }

            public boolean shouldAddToWindow(boolean isMainWindow, Set<Class<?>> contextTypes) {
                return true;
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&Help", "&About Ghidra"}, null, "ZZA"));
        action.setHelpLocation(new HelpLocation("About", "About_Ghidra"));
        action.setEnabled(true);
        this.addAction((DockingActionIf)action);
        DockingAction userAgreementAction = new DockingAction("User Agreement", "Tool"){

            public void actionPerformed(ActionContext context) {
                DockingWindowManager.showDialog((DialogComponentProvider)new UserAgreementDialog(false, false));
            }

            public boolean shouldAddToWindow(boolean isMainWindow, Set<Class<?>> contextTypes) {
                return true;
            }
        };
        userAgreementAction.setMenuBarData(new MenuData(new String[]{"&Help", "&User Agreement"}, null, "AAAHelpContents"));
        userAgreementAction.setHelpLocation(new HelpLocation("About", "User_Agreement"));
        userAgreementAction.setEnabled(true);
        this.addAction((DockingActionIf)userAgreementAction);
        final ErrorReporter reporter = ErrLogDialog.getErrorReporter();
        if (reporter != null) {
            action = new DockingAction("Report Bug", "Tool"){

                public void actionPerformed(ActionContext context) {
                    reporter.report((Component)PluginTool.this.getToolFrame(), "User Bug Report", null);
                }

                public boolean shouldAddToWindow(boolean isMainWindow, Set<Class<?>> contextTypes) {
                    return true;
                }
            };
            action.setMenuBarData(new MenuData(new String[]{"&Help", "&Report Bug..."}, null, "BBB"));
            action.setHelpLocation(new HelpLocation("ErrorReporting", "Report_Bug"));
            action.setEnabled(true);
            this.addAction((DockingActionIf)action);
        }
        final HelpService help = Help.getHelpService();
        action = new DockingAction("Contents", "Tool"){

            public void actionPerformed(ActionContext context) {
                help.showHelp(null, false, (Component)PluginTool.this.getToolFrame());
            }

            public boolean shouldAddToWindow(boolean isMainWindow, Set<Class<?>> contextTypes) {
                return true;
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&Help", "&Contents"}, null, "AAAHelpContents"));
        action.setEnabled(true);
        action.setHelpLocation(new HelpLocation("Misc", "Welcome_to_Ghidra_Help"));
        this.addAction((DockingActionIf)action);
    }

    public void clearLastEvents() {
        this.eventMgr.clearLastEvents();
    }

    public List<DockingActionIf> getPopupActions(ActionContext context) {
        ArrayList<DockingActionIf> actionList = new ArrayList<DockingActionIf>();
        for (PopupListener pl : this.popupListeners) {
            List<DockingActionIf> actions = pl.getPopupActions(context);
            if (actions == null) continue;
            actionList.addAll(actions);
        }
        return actionList;
    }

    @Override
    public void close() {
        if (this.canClose(false) && this.pluginMgr.saveData()) {
            this.doClose();
        }
    }

    private void doClose() {
        if (!this.doSaveTool()) {
            return;
        }
        this.exit();
        this.toolServices.closeTool(this);
    }

    @Override
    public boolean shouldSave() {
        return this.configChangedFlag;
    }

    protected boolean doSaveTool() {
        if (this.toolServices.canAutoSave(this)) {
            this.saveTool();
        } else if (this.configChangedFlag) {
            boolean didSave;
            int result = OptionDialog.showOptionDialog((Component)this.getToolFrame(), (String)SAVE_DIALOG_TITLE, (String)"This tool has changed.  There are/were multiple instances of this tool\nrunning and Ghidra cannot determine if this tool instance should\nautomatically be saved.  Do you want to save the configuration of this tool\ninstance?", (String)"Save", (String)"Save As...", (String)"Don't Save", (int)2);
            if (result == 0) {
                return false;
            }
            if (result == 1) {
                this.saveTool();
            } else if (result == 2 && !(didSave = this.saveToolAs())) {
                return this.doSaveTool();
            }
        }
        return true;
    }

    @Override
    public boolean canClose(boolean isExiting) {
        if (this.taskMgr.isBusy()) {
            if (isExiting) {
                int result = OptionDialog.showYesNoDialog((Component)this.getToolFrame(), (String)"Tool Busy Executing Task", (String)"The tool is busy performing a background task.\n If you continue the task may be terminated and some work may be lost!\n\nContinue anyway?");
                if (result == 2) {
                    return false;
                }
                this.taskMgr.stop(false);
            } else {
                this.getToolFrame().getToolkit().beep();
                Msg.showInfo(this.getClass(), (Component)this.getToolFrame(), (String)"Tool Busy", (Object)"You must stop all background tasks before exiting.");
                return false;
            }
        }
        return this.pluginMgr.canClose();
    }

    public boolean canCloseDomainObject(DomainObject dObj) {
        if (this.taskMgr.hasTasksForDomainObject(dObj)) {
            Msg.showInfo(this.getClass(), (Component)this.getToolFrame(), (String)("Close " + dObj.getName() + " Failed"), (Object)("The tool is currently working in the background on " + dObj.getName() + ".\nPlease stop the backgound processing first."));
            return false;
        }
        return this.pluginMgr.canCloseDomainObject(dObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canCloseDomainFile(DomainFile domainFile) {
        Object consumer = new Object();
        DomainObject domainObject = domainFile.getOpenedDomainObject(consumer);
        if (domainObject == null) {
            return true;
        }
        try {
            boolean bl = this.canCloseDomainObject(domainObject);
            return bl;
        }
        finally {
            domainObject.release(consumer);
        }
    }

    public void prepareToSave(DomainObject dobj) {
        this.pluginMgr.prepareToSave(dobj);
    }

    public void setSize(int width, int height) {
        this.winMgr.getMainWindow().setSize(new Dimension(width, height));
    }

    public Dimension getSize() {
        return this.winMgr.getMainWindow().getSize();
    }

    public void setLocation(int x, int y) {
        this.winMgr.getMainWindow().setLocation(x, y);
    }

    public Point getLocation() {
        return this.winMgr.getMainWindow().getLocation();
    }

    private void updateTitle() {
        Object title = this.fullName;
        if (this.subTitle != null) {
            title = (String)title + ": " + this.subTitle;
        }
        this.winMgr.setToolName((String)title);
    }

    protected void restoreOptionsFromXml(Element root) {
        this.optionsMgr.setConfigState(root.getChild("OPTIONS"));
        this.actionMgr.restoreKeyBindings();
        this.setToolOptionsHelpLocation();
    }

    protected void setProject(Project project) {
        this.project = project;
        if (project != null) {
            this.toolServices = project.getToolServices();
        }
    }

    protected void restorePluginsFromXml(Element elem) throws PluginException {
        this.pluginMgr.restorePluginsFromXml(elem);
    }

    PluginEvent[] getLastEvents() {
        return this.eventMgr.getLastEvents();
    }

    void removeAll(String owner) {
        this.actionMgr.removeToolActions(owner);
        this.winMgr.removeAll(owner);
    }

    void registerEventProduced(Class<? extends PluginEvent> eventClass) {
        this.eventMgr.addEventProducer(eventClass);
    }

    void addEventListener(Class<? extends PluginEvent> eventClass, PluginEventListener listener) {
        this.eventMgr.addEventListener(eventClass, listener);
    }

    void unregisterEventProduced(Class<? extends PluginEvent> eventClass) {
        this.eventMgr.removeEventProducer(eventClass);
    }

    public void addListenerForAllPluginEvents(PluginEventListener listener) {
        this.eventMgr.addAllEventListener(listener);
    }

    public void removeListenerForAllPluginEvents(PluginEventListener listener) {
        this.eventMgr.removeAllEventListener(listener);
    }

    void removeEventListener(Class<? extends PluginEvent> eventClass, PluginEventListener listener) {
        this.eventMgr.removeEventListener(eventClass, listener);
    }

    void removeEventListener(String className) {
        this.eventMgr.removeEventListener(className);
    }

    public void showEditWindow(String defaultText, Component comp, Rectangle rect, EditListener listener) {
        this.winMgr.showEditWindow(defaultText, comp, rect, listener);
    }

    public void setMenuGroup(String[] menuPath, String group) {
        this.winMgr.setMenuGroup(menuPath, group);
    }

    public void setMenuGroup(String[] menuPath, String group, String menuSubGroup) {
        this.winMgr.setMenuGroup(menuPath, group, menuSubGroup);
    }

    public void cancelCurrentTask() {
        this.taskMgr.cancelCurrentTask();
    }

    private void setToolOptionsHelpLocation() {
        ToolOptions opt = this.getOptions("Tool");
        opt.setOptionsHelpLocation(new HelpLocation("Tool", "OptionsForTool"));
        opt = this.getOptions("Key Bindings");
        opt.setOptionsHelpLocation(new HelpLocation("Tool", "KeyBindings_Option"));
    }

    public TransientToolState getTransientState() {
        return this.pluginMgr.getTransientState();
    }

    public UndoRedoToolState getUndoRedoToolState(DomainObject domainObject) {
        return this.pluginMgr.getUndoRedoToolState(domainObject);
    }

    public void showDialog(DialogComponentProvider dialogComponent) {
        DockingWindowManager.showDialog((DialogComponentProvider)dialogComponent);
    }

    public void showDialogOnActiveWindow(DialogComponentProvider dialogComponent) {
        DockingWindowManager.showDialogOnActiveWindow((DialogComponentProvider)dialogComponent);
    }

    public void showDialog(DialogComponentProvider dialogComponent, ComponentProvider centeredOnProvider) {
        this.winMgr.showDialog(dialogComponent, centeredOnProvider);
    }

    public void showDialog(DialogComponentProvider dialogComponent, Component centeredOnComponent) {
        DockingWindowManager.showDialog((Window)this.getToolFrame(), (DialogComponentProvider)dialogComponent, (Component)centeredOnComponent);
    }

    public ComponentProvider getComponentProvider(String name) {
        return this.winMgr.getComponentProvider(name);
    }

    public Window getActiveWindow() {
        return this.winMgr.getActiveWindow();
    }

    public ComponentProvider getActiveComponentProvider() {
        return this.winMgr.getActiveComponentProvider();
    }

    public void contextChanged(ComponentProvider provider) {
        this.winMgr.contextChanged(provider);
    }

    public void addContextListener(DockingContextListener listener) {
        this.winMgr.addContextListener(listener);
    }

    public void removeContextListener(DockingContextListener listener) {
        this.winMgr.removeContextListener(listener);
    }

    public void refreshKeybindings() {
        this.actionMgr.restoreKeyBindings();
    }

    public void setUnconfigurable() {
        this.isConfigurable = false;
    }

    public boolean isConfigurable() {
        return this.isConfigurable;
    }

    public void removePreferenceState(String name) {
        this.winMgr.removePreferenceState(name);
    }

    public Window getProviderWindow(ComponentProvider componentProvider) {
        return this.winMgr.getProviderWindow(componentProvider);
    }

    private <T extends Throwable> void checkedRunSwingNow(CheckedRunnable<T> r, Class<T> exceptionClass) throws T {
        AtomicReference caughtException = new AtomicReference();
        SystemUtilities.runSwingNow(() -> {
            try {
                r.run();
            }
            catch (Throwable th) {
                caughtException.set(th);
            }
        });
        Throwable th = (Throwable)caughtException.get();
        if (th != null) {
            if (exceptionClass.isInstance(th)) {
                throw (Throwable)exceptionClass.cast(th);
            }
            throw new RuntimeException("Unexpected exception type " + th.getClass(), th);
        }
    }

    private static interface CheckedRunnable<T extends Throwable> {
        public void run() throws T;
    }

    private class ToolOptionsListener
    implements OptionsChangeListener {
        private ToolOptionsListener() {
        }

        public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
            PluginTool.this.optionsChanged((Options)options, name, oldValue, newValue);
        }
    }
}

