/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.DialogComponentProvider;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.framework.main.datatable.ProjectDataTreeContextAction;
import ghidra.framework.main.datatree.FindCheckoutsDialog;
import ghidra.framework.main.datatree.ProjectDataTreeActionContext;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.plugintool.Plugin;
import ghidra.util.HelpLocation;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.MultiIcon;
import resources.ResourceManager;

public class FindCheckoutsAction
extends ProjectDataTreeContextAction {
    private Plugin plugin;

    public FindCheckoutsAction(String owner, Plugin plugin) {
        super("Find Checkouts", owner);
        this.plugin = plugin;
        String group = "Repository";
        ImageIcon searchIcon = ResourceManager.loadImage((String)"images/magnifier.png");
        ImageIcon smallCheckIcon = ResourceManager.loadImage((String)"images/check.png");
        MultiIcon icon = new MultiIcon((Icon)searchIcon);
        icon.addIcon((Icon)smallCheckIcon);
        this.setToolBarData(new ToolBarData((Icon)icon, group));
        this.setPopupMenuData(new MenuData(new String[]{"Find Checkouts..."}, (Icon)icon, "Repository"));
        this.setDescription("Find my checkouts recursively");
        this.setHelpLocation(new HelpLocation("VersionControl", "Find_Checkouts"));
        this.setEnabled(false);
    }

    @Override
    protected void actionPerformed(ProjectDataTreeActionContext context) {
        DomainFolder domainFolder = context.getSelectedFolders().get(0);
        this.findCheckouts(domainFolder, context.getComponent());
    }

    @Override
    protected boolean isEnabledForContext(ProjectDataTreeActionContext context) {
        if (context.isReadOnlyProject()) {
            return false;
        }
        return context.getFolderCount() == 1;
    }

    private void findCheckouts(DomainFolder folder, Component comp) {
        FindCheckoutsDialog dialog = new FindCheckoutsDialog(this.plugin, folder);
        this.plugin.getTool().showDialog((DialogComponentProvider)dialog, comp);
    }
}

