/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.logviewer.ui;

import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import java.awt.Color;
import java.awt.Component;
import org.apache.logging.log4j.Level;

public class LogLevelTableCellRenderer
extends GTableCellRenderer {
    private static final Color TRACE_COLOR = Color.WHITE;
    private static final Color DEBUG_COLOR = new Color(135, 191, 212);
    private static final Color INFO_COLOR = new Color(225, 225, 225);
    private static final Color WARN_COLOR = new Color(255, 236, 50);
    private static final Color ERROR_COLOR = Color.RED;
    private static final Color FATAL_COLOR = Color.RED.darker();

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        super.getTableCellRendererComponent(data);
        Object value = data.getValue();
        this.setForeground(Color.black);
        if (value.toString().equalsIgnoreCase(Level.DEBUG.toString())) {
            this.setBackground(DEBUG_COLOR);
        } else if (value.toString().equalsIgnoreCase(Level.TRACE.toString())) {
            this.setBackground(TRACE_COLOR);
        } else if (value.toString().equalsIgnoreCase(Level.WARN.toString())) {
            this.setBackground(WARN_COLOR);
        } else if (value.toString().equalsIgnoreCase(Level.INFO.toString())) {
            this.setBackground(INFO_COLOR);
        } else if (value.toString().equalsIgnoreCase(Level.ERROR.toString())) {
            this.setBackground(ERROR_COLOR);
        } else if (value.toString().equalsIgnoreCase(Level.FATAL.toString())) {
            this.setBackground(FATAL_COLOR);
        }
        return this;
    }
}

