/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.wizard.AbstractWizardJPanel;
import docking.wizard.PanelManager;
import ghidra.framework.main.NewProjectPanelManager;
import ghidra.util.HelpLocation;
import ghidra.util.layout.VerticalLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class ProjectTypePanel
extends AbstractWizardJPanel {
    private JRadioButton sharedRB;
    private JRadioButton nonSharedRB;
    private ButtonGroup buttonGroup;
    private PanelManager panelManager;

    ProjectTypePanel(PanelManager panelManager) {
        this.panelManager = panelManager;
        this.buildPanel();
        this.setBorder(NewProjectPanelManager.EMPTY_BORDER);
    }

    private void buildPanel() {
        JPanel innerPanel = new JPanel((LayoutManager)new VerticalLayout(10));
        innerPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ProjectTypePanel.this.panelManager.getWizardManager().validityChanged();
            }
        };
        this.nonSharedRB = new JRadioButton("Non-Shared Project", true);
        this.nonSharedRB.addItemListener(listener);
        this.nonSharedRB.setToolTipText("Create a project that is not shared with others");
        this.sharedRB = new JRadioButton("Shared Project");
        this.sharedRB.addItemListener(listener);
        this.sharedRB.setToolTipText("Create a project that can be shared with others");
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.nonSharedRB);
        this.buttonGroup.add(this.sharedRB);
        innerPanel.add(this.nonSharedRB);
        innerPanel.add(this.sharedRB);
        JPanel outerPanel = new JPanel();
        outerPanel.setBorder(BorderFactory.createEmptyBorder());
        outerPanel.add(innerPanel);
        this.add(outerPanel);
    }

    public String getTitle() {
        return "Select Project Type";
    }

    public void initialize() {
        this.buttonGroup.remove(this.sharedRB);
        this.buttonGroup.remove(this.nonSharedRB);
        this.sharedRB.setSelected(false);
        this.sharedRB.setSelected(false);
        this.buttonGroup.add(this.nonSharedRB);
        this.buttonGroup.add(this.sharedRB);
    }

    public boolean isValidInformation() {
        return this.sharedRB.isSelected() || this.nonSharedRB.isSelected();
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("FrontEndPlugin", "SelectProjectType");
    }

    boolean isSharedProject() {
        return this.sharedRB.isSelected();
    }
}

