/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.combobox.GhidraComboBox;
import ghidra.bitpatterns.gui.InputDialogComponentProvider;
import ghidra.bitpatterns.gui.RegisterValueWrapper;
import ghidra.bitpatterns.info.ContextRegisterExtent;
import ghidra.bitpatterns.info.ContextRegisterFilter;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ContextRegisterFilterInputDialog
extends InputDialogComponentProvider {
    private static final int TEXT_FIELD_COLUMNS = 10;
    private Map<String, GhidraComboBox<RegisterValueWrapper>> regsToBoxes;
    private ContextRegisterExtent extent;

    public ContextRegisterFilterInputDialog(String title, ContextRegisterExtent extent, Component parent) {
        super(title);
        this.extent = extent;
        this.regsToBoxes = new HashMap<String, GhidraComboBox<RegisterValueWrapper>>();
        JPanel panel = this.createPanel();
        this.addWorkPanel(panel);
        this.addOKButton();
        this.okButton.setText("Apply");
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        HelpLocation helpLocation = new HelpLocation("FunctionBitPatternsExplorerPlugin", "Context_Register_Filters");
        this.setHelpLocation(helpLocation);
        DockingWindowManager.showDialog((Component)parent, (DialogComponentProvider)this);
    }

    @Override
    protected JPanel createPanel() {
        JPanel panel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(panel, 1);
        panel.setLayout(boxLayout);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        for (String currentRegister : this.extent.getContextRegisters()) {
            JPanel currentRegPanel = new JPanel();
            PairLayout pairLayout = new PairLayout();
            currentRegPanel.setLayout((LayoutManager)pairLayout);
            JTextField currentTextField = new JTextField(currentRegister, 10);
            currentTextField.setEditable(false);
            currentRegPanel.add(currentTextField);
            List<BigInteger> regValues = this.extent.getValuesForRegister(currentRegister);
            Object[] valueArray = new RegisterValueWrapper[regValues.size() + 1];
            valueArray[0] = new RegisterValueWrapper(null);
            for (int i = 1; i < regValues.size() + 1; ++i) {
                valueArray[i] = new RegisterValueWrapper(regValues.get(i - 1));
            }
            GhidraComboBox currentCombo = new GhidraComboBox(valueArray);
            currentRegPanel.add((Component)currentCombo);
            panel.add(currentRegPanel);
            this.regsToBoxes.put(currentRegister, (GhidraComboBox<RegisterValueWrapper>)currentCombo);
        }
        return panel;
    }

    public ContextRegisterFilter getFilter() {
        if (this.isCanceled) {
            return null;
        }
        ContextRegisterFilter registerFilter = new ContextRegisterFilter();
        for (String currentRegister : this.regsToBoxes.keySet()) {
            BigInteger value = ((RegisterValueWrapper)this.regsToBoxes.get(currentRegister).getSelectedItem()).getValue();
            if (value == null) continue;
            registerFilter.addRegAndValueToFilter(currentRegister, value);
        }
        return registerFilter;
    }
}

