/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.textfield.IntegerTextField;
import ghidra.bitpatterns.gui.InputDialogComponentProvider;
import ghidra.bitpatterns.info.ByteSequenceLengthFilter;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ByteSequenceLengthFilterInputDialog
extends InputDialogComponentProvider {
    private IntegerTextField indexBox;
    private IntegerTextField minLengthBox;
    private static final String INDEX_BOX_TITLE_TEXT = "Prefix Length in Bytes (Negative for Suffix): ";
    private static final String LENGTH_BOX_TITLE_TEXT = "Minimum Length in Bytes of String:";
    private static final String OK_BUTTON_TEXT = "Apply";

    protected ByteSequenceLengthFilterInputDialog(String title, Component parent) {
        super(title);
        JPanel panel = this.createPanel();
        this.addWorkPanel(panel);
        this.addOKButton();
        this.okButton.setText(OK_BUTTON_TEXT);
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        HelpLocation helpLocation = new HelpLocation("FunctionBitPatternsExplorerPlugin", "Length_Filters");
        this.setHelpLocation(helpLocation);
        DockingWindowManager.showDialog((Component)parent, (DialogComponentProvider)this);
    }

    @Override
    protected JPanel createPanel() {
        JPanel mainPanel = new JPanel();
        PairLayout pairLayout = new PairLayout();
        mainPanel.setLayout((LayoutManager)pairLayout);
        mainPanel.add(new JLabel(INDEX_BOX_TITLE_TEXT));
        this.indexBox = new IntegerTextField();
        mainPanel.add(this.indexBox.getComponent());
        mainPanel.add(new JLabel(LENGTH_BOX_TITLE_TEXT));
        this.minLengthBox = new IntegerTextField();
        mainPanel.add(this.minLengthBox.getComponent());
        return mainPanel;
    }

    public ByteSequenceLengthFilter getValue() {
        int minLength;
        int index = this.indexBox.getIntValue();
        if (index > (minLength = this.minLengthBox.getIntValue())) {
            return null;
        }
        try {
            return new ByteSequenceLengthFilter(index, minLength);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

