/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.util;

import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Vector;

public class MapBinaryHeap<T>
extends AbstractCollection<T>
implements Queue<T> {
    private Vector<T> heap = new Vector();
    private Map<T, Integer> object_indices = new HashMap<T, Integer>();
    private Comparator<T> comp;
    private static final int TOP = 0;

    public MapBinaryHeap(Comparator<T> comp) {
        this.initialize(comp);
    }

    public MapBinaryHeap() {
        this.initialize(new ComparableComparator());
    }

    public MapBinaryHeap(Collection<T> c) {
        this();
        this.addAll(c);
    }

    public MapBinaryHeap(Collection<T> c, Comparator<T> comp) {
        this(comp);
        this.addAll(c);
    }

    private void initialize(Comparator<T> comp) {
        this.comp = comp;
        this.clear();
    }

    @Override
    public void clear() {
        this.object_indices.clear();
        this.heap.clear();
    }

    @Override
    public boolean add(T o) {
        int i = this.heap.size();
        this.heap.setSize(i + 1);
        this.percolateUp(i, o);
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.heap.isEmpty();
    }

    @Override
    public T peek() {
        if (this.heap.size() > 0) {
            return this.heap.elementAt(0);
        }
        return null;
    }

    @Override
    public int size() {
        return this.heap.size();
    }

    public void update(T o) {
        int cur = this.object_indices.get(o);
        int new_idx = this.percolateUp(cur, o);
        this.percolateDown(new_idx);
    }

    @Override
    public boolean contains(Object o) {
        return this.object_indices.containsKey(o);
    }

    private void percolateDown(int cur) {
        int left = this.lChild(cur);
        int right = this.rChild(cur);
        int smallest = left < this.heap.size() && this.comp.compare(this.heap.elementAt(left), this.heap.elementAt(cur)) < 0 ? left : cur;
        if (right < this.heap.size() && this.comp.compare(this.heap.elementAt(right), this.heap.elementAt(smallest)) < 0) {
            smallest = right;
        }
        if (cur != smallest) {
            this.swap(cur, smallest);
            this.percolateDown(smallest);
        }
    }

    private int percolateUp(int cur, T o) {
        int i = cur;
        while (i > 0 && this.comp.compare(this.heap.elementAt(this.parent(i)), o) > 0) {
            T parentElt = this.heap.elementAt(this.parent(i));
            this.heap.setElementAt(parentElt, i);
            this.object_indices.put(parentElt, new Integer(i));
            i = this.parent(i);
        }
        this.object_indices.put(o, new Integer(i));
        this.heap.setElementAt(o, i);
        return i;
    }

    private int lChild(int i) {
        return (i << 1) + 1;
    }

    private int rChild(int i) {
        return (i << 1) + 2;
    }

    private int parent(int i) {
        return i - 1 >> 1;
    }

    private void swap(int i, int j) {
        T iElt = this.heap.elementAt(i);
        T jElt = this.heap.elementAt(j);
        this.heap.setElementAt(jElt, i);
        this.object_indices.put(jElt, new Integer(i));
        this.heap.setElementAt(iElt, j);
        this.object_indices.put(iElt, new Integer(j));
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.unmodifiableIterator(this.heap.iterator());
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T element() throws NoSuchElementException {
        T top = this.peek();
        if (top == null) {
            throw new NoSuchElementException();
        }
        return top;
    }

    @Override
    public boolean offer(T o) {
        return this.add(o);
    }

    @Override
    public T poll() {
        T top = this.peek();
        if (top != null) {
            T bottom_elt = this.heap.lastElement();
            this.heap.setElementAt(bottom_elt, 0);
            this.object_indices.put(bottom_elt, new Integer(0));
            this.heap.setSize(this.heap.size() - 1);
            if (this.heap.size() > 1) {
                this.percolateDown(0);
            }
            this.object_indices.remove(top);
        }
        return top;
    }

    @Override
    public T remove() {
        T top = this.poll();
        if (top == null) {
            throw new NoSuchElementException();
        }
        return top;
    }

    private class ComparableComparator
    implements Comparator<T> {
        private ComparableComparator() {
        }

        @Override
        public int compare(T arg0, T arg1) {
            if (!(arg0 instanceof Comparable) || !(arg1 instanceof Comparable)) {
                throw new IllegalArgumentException("Arguments must be Comparable");
            }
            return ((Comparable)arg0).compareTo(arg1);
        }
    }
}

